#include "mbed.h"
#include <cmath>

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
Serial com_lpc1114(p13, p14);

LocalFileSystem local("local");  // define Mount Point(which becomes Direcory Path)

void echoback()
{
    char str[6] = "HELLO";

    com_lpc1114.putc(0x11); //Functional
    com_lpc1114.putc(6);    //size of echo
    pc.printf("echoback: ");
    for(char ch = 0; ch < 6; ch++) {
        com_lpc1114.putc(str[ch]);
        pc.printf("%c",com_lpc1114.getc());
    }
    pc.putc('\n');

}

int main()
{
    FILE* fp;
    char cfp;
    unsigned short dtc;
    char ctmp;
    unsigned short dtmp;

    pc.printf("\nPROGRAM BEGIN\n");

    pc.printf("\nselect ch.0\n");
    com_lpc1114.putc(0);

    cfp = pc.getc();
    if(cfp == 'l') {
        fp = fopen("/local/SENSOR00.SAV", "rb");
        if (fp == NULL) pc.printf("\nfopen failured\n");

        pc.printf("\nload save data to lpc1114\n");
        com_lpc1114.putc('l');
        pc.printf("ACK recieved :");
        //for(int i = 0; i < 9 * 256 + 3 + 6 * 5; i++) {
        int i = 0;

        while(1) {
            fread(&cfp, sizeof(char), 1, fp);
            com_lpc1114.putc(cfp);
            if(i % 3 == 2) {
                cfp = com_lpc1114.getc();
                if (cfp == 0x06) {
                    for(double j = 0.0; j < log10(static_cast<double>(i / 3 + 1)); j += 1.0)
                        pc.putc(0x08);
                    pc.printf("%d", i / 3 + 1);
                    //pc.getc();
                }//
                else if (cfp == 0x04) {
                    //cfp = com_lpc1114.getc();
                    //if (cfp == 0x04) {
                    pc.printf("\nSUCCESSED");
                    break;
                    //}
                }
            }
            i++;
        }
        fclose(fp);
    }

    else if (cfp == 'c') {
        fp = fopen("/local/SENSOR00.SAV", "wb");
        if (fp == NULL) pc.printf("\nfopen failured\n");

        com_lpc1114.putc('c');
        pc.printf("sampling:0");
        for(int i = 0; i < 5; i++){
            pc.putc(0x08);
            pc.printf("%d", com_lpc1114.getc());
        }
        pc.putc('\n');
        pc.printf("\nsave data from lpc1114\n");
        while(1) {
            ctmp = com_lpc1114.getc();
            if(ctmp == 0x04)break;
            dtmp = (static_cast<unsigned short>(ctmp) << 8);
            ctmp = com_lpc1114.getc();
            dtmp = dtmp | ctmp;
            ctmp = com_lpc1114.getc();
            com_lpc1114.putc(0x06);
            fwrite(&dtmp, sizeof(unsigned short), 1, fp);
            fwrite(&ctmp, sizeof(char), 1, fp);
        }
        pc.printf("\nSUCCESSED");

        fclose(fp);
    }



    pc.printf("\nLOOP\n");

    echoback();

    printf("dtc: 000");
    while(1) {
        myled = 1;
        wait(0.2);
        com_lpc1114.putc(0x12);//Functional
        dtc = com_lpc1114.getc();
        dtc = ((dtc << 8) | com_lpc1114.getc());
        for(int j = 0; j < 3; j++)
            pc.putc(0x08);
        printf("%3d", dtc);
        myled = 0;
        wait(0.2);
        if(pc.readable()) {
            pc.getc();
            pc.putc('\n');
            break;
        }
    }

}
