#include "mbed.h"
#include "TRP105F_Spline.h"
#include "TRP105FS_SPIWrapper.h"

Serial pc(USBTX, USBRX); // tx, rx ( the usb serial communication )
extern AnalogIn* g_Sensor_Voltage;
DigitalOut myled1(LED1),myled2(LED2);
Timer t;
TRP105FS TRP(5, AsDEBUG, p16);


SPI_TRP105FS sensor[8] = {
    SPI_TRP105FS(0),
    SPI_TRP105FS(1),
    SPI_TRP105FS(2),
    SPI_TRP105FS(3),
    SPI_TRP105FS(4),
    SPI_TRP105FS(5),
    SPI_TRP105FS(6),
    SPI_TRP105FS(7)
};

//  A sensor Calibration 
//  個別キャリブレーション
void calibrateSensor(unsigned int ch)//channel
{
    char c;

    printf("\nload save-data or calibration[l/c]>");
    c = pc.getc();
    if(c == 'l') {
        printf("%c\n",c);
        printf("Now loading...\n");
        sensor[ch].loaddata();
        printf("Done.\n");
    } else {
        printf("%c\n",c);
        for(int i = 0; i < sensor[ch].getNsample(); i++) {
            printf("press ENTER holding the distance at <%d>", i * 255 / 4);
            do {
                c = pc.getc();
            } while (!( c == 0x0a || c == 0x0d ));
            printf("\n");
            sensor[ch].setSample(i * 255 / 4);
        }
        printf("Done.\n");
        printf("Now Calibrating...\n");
        sensor[ch].calibrate();
        printf("Done.\n");
        printf("Calibration Result being saved...\n");
        sensor[ch].savedata();
        printf("Done.\n");
    }
}

//  Multiple Sensors Calibration(Not Tested)
//  一斉キャリブレーション（動作未確認）
void calibrateSensor(unsigned int ch_first, unsigned int ch_end, unsigned int ch_teacher)
{
    printf("Calibration at once");
    unsigned int nsample = sensor[ch_teacher].getNsample();
    unsigned short dst;
    bool* bnsample = new bool[nsample];
    bool flag = false;
    unsigned int n_ui;

    for (int i = 0; i < nsample; i++) bnsample[i] = false;
    printf("Press keys at once...");
    do {
        dst = sensor[ch_teacher].getDistance();

        for (unsigned int i = 0; i < nsample; i++) {
            if(dst == i * 255 / (nsample - 1)) {
                flag = true;
                n_ui = i;
            }
        }

        if(flag || (!bnsample[n_ui])) {
            for(unsigned int ch = ch_first; ch < ch_end + 1; ch++) {
                if(ch != ch_teacher)sensor[ch].setSample(dst);
            }
            bnsample[n_ui] = true;
        }
        for (unsigned int i = 0; i < nsample; i++) {
            if(bnsample[i] == false) flag = false;
        }
    } while(!flag);
    printf("Done.\n");
    for (unsigned int ch = 0; ch < nsample; ch++) {
        sensor[ch].calibrate();
        sensor[ch].savedata();
    }

    delete[] bnsample;
}

//Main
int main()
{
    // Setup the spi for 7 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    sensor[0].spi.format(16,0);
    sensor[0].spi.frequency(1000000);

    calibrateSensor(0);       //calibration sensor channel 0 
    //calibrateSensor(1);         //calibration sensor channel 1
    //calibrateSensor(1,2,0);   //Multiple Calibration channel 1-2, sensor channel 0 is teacher.

    myled1 = 1;
    myled2 = 1;
    unsigned short dst;
    while(1) {
        t.start();
        dst = sensor[0].getDistance();
        //dst = sensor[1].getDistance();
        
        t.stop();
        printf("dst:%d(%f s)\n",dst, t.read());
        t.reset();
        //printf("vol:%d\n",SPI_TPR105FS::ADread(0));

        wait(0.1);
        pc.putc('\n');
        //  if 'p' is pressed quit the loop
        if(pc.readable())if(pc.getc() == 'q') break;
    }
    myled1 = myled2 = 0;

}
