#include "mbed.h"
#include "CODE_SELECTIVE.h"
#include "TRP105F_Spline.h"

DigitalOut myled(LED1);
DigitalIn  unisig(dp13);
TRP105FS sensor(5, dp4);
Serial com_lpc1768(dp16, dp15);

int main()
{
    char c;
    unsigned short x;

    while(1) {
        c = com_lpc1768.getc();

        if(c == 0) {
            c = com_lpc1768.getc();
            switch(c) {
                case 'c':
                    for(int i = 0; i < 5; i++) {
                        while( unisig){;}
                        while(!unisig){;}
                        sensor.setSample(i * 255 / 4, sensor.getVoltage());
                        com_lpc1768.putc(i + 1);
                    }
                    sensor.calibrate();
                    sensor.saveSetting_intoSerial(&com_lpc1768);
                    break;
                case 'l':
                    sensor.loadSetting_fromSerial(&com_lpc1768);
                    break;
            }

            while(1) {
                myled = 1;
                c = com_lpc1768.getc();
                if(c == 0x11) {
                    c = com_lpc1768.getc();
                    for(int i = 0; i < c; i++)
                        com_lpc1768.putc(com_lpc1768.getc());
                }//

                else if (c == 0x12) {
                    myled = 0;
                    x = sensor.getDistance();
                    com_lpc1768.putc((x>>8)&0xFF);
                    com_lpc1768.putc((x   )&0xFF);
                }

            }

        }
    }
}
