/** Defining Discretized Sinusoidal Wave Model 
 *
 *  \file   DSin.h
 *  \author Akifumi Takahashi
 *  \date   2019/Nov/28 ver.1 publish
 *  \version 1.0.2019.Nov
 *  \version 2.0.2019.Dec
 */
 
#ifndef DISCRETIZED_SINUSOIDAL_WAVE_MODEL_H
#define DISCRETIZED_SINUSOIDAL_WAVE_MODEL_H
#define _USE_MATH_DEFINES
#include <cmath>

#ifndef M_PI
#define M_PI 3.141592
#endif

#include "mbed.h"
/** \Class DISCRETIZED SINUSOIDAL WAVE MODEL
 *
 *  Model of a discretized sinusoidal wave whose value type is float, 
 *  and the range is from (-1.0f * ampl) to (1.0f * ampl).
 *
 */
class DSin
{
private:
    /// Amplitude of sinusoidal wave (mA)
    float m_ampl;
    
    /// Frequency of the wave (Hz)
    uint16_t m_freq;
    
    /// Pulse width fineness of dicretization (us) 
    /// pwth = 1000000 / freq / resolution_ofsin;
    uint16_t m_pwth;
    
    float*      m_discretized_sin;
    int32_t*    m_discretized_sin_p16m16;
    
    void init();

public:
    float const ampl_max;
    uint16_t const freq_max;
    uint16_t const resolution_ofsin; // = arg_resolution_ofsin below
    
    DSin(
        uint16_t const arg_resolution_ofsin = 20
    );
    DSin(
        float const arg_ampl,
        uint16_t const arg_freq,
        uint16_t const arg_resolution_ofsin = 20
    );
    
    void setParam(
        float const arg_ampl,
        uint16_t const arg_freq
    );
    
    void setAmplitude(
        float const arg_ampl
    );
    
    void setFrequency(
        uint16_t const arg_freq
    );
    
    float getValue();
    int32_t getValue_p16m16();
    
    void getValueofSamplePoints(float[]);
    
    float    getAmplitude();    //inline
    uint16_t getFrequency();    //inline
    uint16_t getPulseWidth(); //inline
    
};


inline float DSin::getAmplitude()
{
    return m_ampl;
}

inline uint16_t DSin::getFrequency()
{
    return m_freq;
}

inline uint16_t DSin::getPulseWidth()
{
    return m_pwth;
}
#endif