#include "DSin.h"

DSin::DSin(
    uint16_t const arg_resolution_ofsin
):
    ampl_max(10),
    freq_max(5000),
    resolution_ofsin(arg_resolution_ofsin)
{
    init();
    setParam(0, 4000);
}

DSin::DSin(
    float const arg_ampl,
    uint16_t const arg_freq,
    uint16_t const arg_resolution_ofsin
): 
    ampl_max(10),
    freq_max(5000),
    resolution_ofsin(arg_resolution_ofsin)
{
    init();
    setParam(arg_ampl, arg_freq);
}

void DSin::setParam(
    float const arg_ampl,
    uint16_t const arg_freq
)
{
    setAmplitude(arg_ampl);
    setFrequency(arg_freq);
}

void DSin::setAmplitude(
    float const arg_ampl
)
{
    m_ampl = arg_ampl;
    for(int i = 0; i < resolution_ofsin; i++){
        m_discretized_sin_p16m16[i] = static_cast<int32_t>(4095.0 / ampl_max * m_ampl * m_discretized_sin[i] );
    }
}

void DSin::setFrequency(
    uint16_t const arg_freq
)
{
    m_freq = arg_freq;
    m_pwth = 1000000 / m_freq / resolution_ofsin;
}

void DSin::init()
{
    m_discretized_sin = new float[resolution_ofsin];
    m_discretized_sin_p16m16 = new int32_t[resolution_ofsin];
    
    for(int i = 0; i < resolution_ofsin; i++){
        m_discretized_sin[i] = sin( 2.0 * M_PI * static_cast<float>(i) / static_cast<float>(resolution_ofsin));
    }
}

float DSin::getValue()
{
    static int itr = 0;
    return m_ampl * m_discretized_sin[itr++ % resolution_ofsin];
}

int32_t DSin::getValue_p16m16()
{
    static int itr = 0;
    return m_discretized_sin_p16m16[itr++ % resolution_ofsin];
}

void DSin::getValueofSamplePoints(float arg_dsin[])
{
    memcpy(arg_dsin, m_discretized_sin, sizeof(float) * resolution_ofsin);
}