#include "mbed.h"
#include "CubicSpline.h"
DigitalOut myled(LED1);
CubicSpline2d sensor(5,AsDEBUG);
extern Serial g_Serial_Signal;
extern AnalogIn g_Sensor_Voltage;

int main()
{
    double x,y;
    Timer t;
    myled = 1;
    printf("c or l>");
    if(g_Serial_Signal.getc() == 'c') {
        sensor.calibrateSensor();
        sensor.printOutData();
        sensor.saveSetting();
    } else {
        sensor.loadSetting();
        printf("press any key");
        g_Serial_Signal.getc();
        sensor.printOutData();
    }
    myled = 0;

    while(1) {
        myled = 1;
        if(g_Serial_Signal.readable()) {
            g_Serial_Signal.getc();
            y = g_Sensor_Voltage.read();
            t.start();
            x = sensor.getX(y);
            t.stop();
            printf("y: %f -> x: %f (time: %f)\n",y, x , t.read());
            t.reset();
            myled = 0;
            wait(0.2);
        }
    }
}
