/**
 *  Spline_Cubic.h,.cpp
 *
 *  Author: aktk, aktk.j.uec@gmail.com
 *  Tokyo, Japan.
 *
 *  LOG:
 *  ver.0   2016/02.12 - 2016/02/16
 *      TRP105F_Spline.h,.cpp(Ver.2.1)
 *  ver.1   2016/05.12
 */
#ifndef Cubic_Spline_H
#define Cubic_Spline_H

#define DEBUG
#define VERSION_C
//#define DEBUG_MAKE_MODEL
//#define DEBUG_SOLVE
//#define DEBUG_GETX "DEBUG_GETX\n"
//#define DEBUG_GETY "DEBUG_GETY\n"

#include "mbed.h"
#include <cmath>
#include <complex>
#include <vector>

//  Vector Element Type
typedef struct {
    double x; //
    double y; //
    double t; //    use as pramameter of x,y.
} Vxyt;

enum UseType {
    AsDEBUG,
    AsMODULE
};

class CubicSpline2d
{
public:
    //  Constraction
    CubicSpline2d();
    CubicSpline2d(unsigned int);
    CubicSpline2d(unsigned int, UseType);
    //  Destraction
    ~CubicSpline2d();
    //  Functions
    double  getX(double arg_y);
    double  getY(double arg_x);
    void    calibrateSensor();
    void    saveSetting();
    void    saveSetting(const char *filename);
    void    loadSetting();
    void    loadSetting(const char *filename);
    void    printOutData();

private:
    //
    //  Variables
    //
    UseType      _useType;
    unsigned int _Sample_Num;   //  the number of samples for derive spline
    Vxyt*        _Sample_Set;
    double*      _C_x[4];    //x = Spline-f(t) = _C_x[0]  + _C_x[1]t  + _C_x[2]t^2  + _C_x[3]t^3
    double*      _C_y[4];    //y = Spline-f(t) = _C_y[0]  + _C_y[1]t  + _C_y[2]t^2  + _C_y[3]t^3
    Vxyt        _Last_Point;
    //
    //
    //
    //
    //  For calibration
    //
    //  sampling data for calibration
    void    _sampleData();
    //  generate a vector of _u_params which is used for Cubic spline model
    void    _makeModel(
        const double* arg_sampled_t,
        const double* arg_sampled_ft,
        /*-*/ double* arg_C[4],
        const unsigned int arg_num
    );
    void    _makeModel(
        const double* arg_sampled_t,
        const double* arg_sampled_ft,
        /*-*/ double* arg_C[4]
    );
    //
    //  For calculation
    //
    //  Fuction to return the value of Cubic polynomial f(t)
    double  _cubic_f(
        const double  arg_t,
        const double  arg_C[4]
    );
    //  Function to solve a cubic polinomial
    //  by using Gardano-Tartaglia formula
    void _solve_cubic_f(
        std::complex<double>* arg_t,
        const double  arg_C[4],
        const double  arg_ft
    );
    //
    //  For debug
    //
    void    _printOutData(
        const unsigned short*   arg,
        const int               num,
        const char*             name);
    void    _printOutData(
        const Vxyt*             arg,
        const int               num,
        const char*             name);
    void    _printOutData(
        const double*           arg, 
        const int               num,
        const char*             name);
    void    _printOutDataCouple(
        const double*           arg1,
        const double*           arg2,
        const int               num,
        const char*             name);
};
#endif