#ifndef BMX055_HPP
#define BMX055_HPP

#include "mbed.h"

//  Aux class
template <typename T = float, unsigned char D = 3>
class FixedLengthVector
{
public:
    const unsigned char degree; // length of array, or num of elements
    
    T * const e; // elements
    
    //elements' alias
    T &w, &x, &y, &z;
    

    FixedLengthVector (T* arg_init_vec = array_filled_0(D))
        :degree(value_checked_degree(D))
        ,e(new T[degree])
        ,w(e[0])
        ,x((degree > 3 ? e[1] : e[0]))
        ,y((degree > 3 ? e[2] : e[1]))
        ,z((degree > 3 ? e[3] : (degree == 3 ? e[2] : e[1])))
    {        
        for (int i = 0; i < degree; i++) e[i] = arg_init_vec[i];
    }


private:
    static inline unsigned char value_checked_degree (unsigned char arg_degree)
    {
        if (arg_degree < 2) return 2;
        else return arg_degree;
    }
    
    static inline T * array_filled_0 (unsigned char arg_degree)
    {
        unsigned char l_degree = value_checked_degree(arg_degree);
        T* tmp = new T[l_degree];

        for(int i = 0; i < l_degree; i++) tmp[i] = 0;
        return tmp;
    }

};

class BMX055
{
public:
    /** Main buffers which store 3 cubic data
     * 
     *  Acc: all x,y,z has 12 bits payload
     *  Gyr: all x,y,z has 16 bits payload
     *  Mag: x,y have 13 bits and z have 15 bits payload
     */
    FixedLengthVector<signed short, 3> acc, gyr, mag;
    
    // I2C pin of LPC 1768 is (p9, p10) or (p28, p27);
    BMX055(
        const char arg_addr_acc = 0x19, 
        const char arg_addr_gyr = 0x69, 
        const char arg_addr_mag = 0x13,
        PinName arg_SDA = p9, 
        PinName arg_SCL = p10)
    : m_addr_acc(arg_addr_acc << 1)
    , m_addr_gyr(arg_addr_gyr << 1)
    , m_addr_mag(arg_addr_mag << 1)
    {
        Init_I2C(arg_SDA, arg_SCL);
    }
    void Update();
    void UpdateIMU();
    
private:
    I2C* i2c;
    const char m_addr_acc;
    const char m_addr_gyr;
    const char m_addr_mag;
    void Init_I2C(PinName arg_SDA, PinName arg_SCL);

};
#endif