#include "AMPulseTrain.h"

AMPulseTrain::AMPulseTrain(
    /// Carrier Pulse Train
    PulseTrain  * arg_carrier,
    /// Initial AM Signal expression
    AMSignal  * arg_signal
):
    Carrier(arg_carrier),
    Signal(arg_signal)
{
    RecalcPulsebaseParameter();
}




uint16_t
AMPulseTrain::getClockperiod_us()
{
    return Carrier->getClockperiod_us();
}

void
AMPulseTrain::incrementClock()
{
    Carrier->incrementClock();
}




void
AMPulseTrain::attachCallback_asClock(
    Callback<void(bool, AMPulseTrain*)> arg_callback
)
{
    m_callback_asClock = arg_callback;
    Carrier->attachCallback_asClock(callback(this, &AMPulseTrain::CallbackWrapper_asClock));
}

void
AMPulseTrain::CallbackWrapper_asClock(bool arg_pulsestate)
{
    m_callback_asClock(arg_pulsestate, this);
}




void
AMPulseTrain::attachCallback_asPulseEdge(
    Callback<void(bool, AMPulseTrain*)> arg_callback
)
{
    m_callback_asPulseEdge = arg_callback;
    Carrier->attachCallback_asPulseEdge(callback(this, &AMPulseTrain::CallbackWrapper_asPulseEdge));
}

void
AMPulseTrain::CallbackWrapper_asPulseEdge(bool arg_pulsestate)
{
    m_callback_asPulseEdge(arg_pulsestate, this);
}




void
AMPulseTrain::attachAMSignalExpression(
    Callback<uint16_t(AMPulseTrain*)> arg_callback
)
{
    m_AMSignalExpression = arg_callback;
    Signal->attachAMSignalExpression(
        callback(this, &AMPulseTrain::CallbackWrapper_AMSignalExpression)
    );
}

uint16_t
AMPulseTrain::CallbackWrapper_AMSignalExpression(AMSignal* arg_signal)
{
    return m_AMSignalExpression(this);
}