#include "AMSignal.h"

void AMSignal::setFrequency(uint16_t const arg_freq)
{
    m_freq = velidateRange<uint16_t>(arg_freq, 1, FREQ_MAX);
    m_period_us = 1000000 / m_freq;
    if(1000000 % m_freq >= (m_freq/2)) m_period_us += 1;
}

void AMSignal::setAmplitude(float const arg_ampl)
{
    m_ampl_u16 = AMPL_MAX_u16 * velidateRange<float>(arg_ampl, 0.0, 1.0);
}

void AMSignal::setAmplitude(uint16_t const arg_ampl)
{
    m_ampl_u16 = arg_ampl;
}

/// Get a parameter which defines the size of pulse hight axis with in [0,1]
float AMSignal::getAmplitude_uf()
{
    return (float) m_ampl_u16 / (float) AMPL_MAX_u16;
}

uint16_t AMSignal::getAmplitude_u16()
{
    return m_ampl_u16;
}

uint16_t AMSignal::getFrequency()
{
    return m_freq;
}

uint16_t AMSignal::getPeriod_us()
{
    return m_period_us;
}


template <typename T>
T AMSignal::velidateRange(T const arg_val, T const arg_min, T const arg_max)
{
    if(arg_val < arg_min) return arg_min;
    else if (arg_val <=  arg_max) return arg_val;
    else return arg_max;
}
