#include "mbed.h"
#include "EthernetInterface.h"
#include "FTPClient.h"
//#define DEBUG
FTPClient::FTPClient(PinName mosi, PinName miso, PinName sclk, PinName ssel, const char* root) : _SDFileSystem(mosi, miso, sclk, ssel, root){
    //printf("Object");
    blogin = false;
    bopenflag = false;
    brfileflag = false;
    bdirflag = false;
    blsflag = false;
    bfdeleteflag = false;
    bmkdirflag = false;
    bcdflag = false;
    bquitflag = false;
    //printf("Object");
}

// made for checking


bool FTPClient::open(char ip[], int port, char id[], char pass[]){
    //printf("\nInside Open");
/*
      printf("\n%s",ip);
      printf("\n%d",port);
      printf("\n%s",id);
      printf("\n%s",pass);
      printf("\nHappens");
      printf("\nHappens\n");
  */
    
    FTPClientControlSock = new TCPSocketConnection();
    FTPClientDataSock = new TCPSocketConnection();
    //printf("\nHappens\n");
    #if 0
    do{
        FTPClientControlSock->connect(ip, port);
    }while(!FTPClientControlSock->is_connected());
    #endif
    #if 1
    while (FTPClientControlSock->connect(ip, port) < 0) {
    #ifdef DEBUG
        printf("Unable to connect to (%s) on port (%d)\r\n", ip, port);
    #endif
        wait(1);
    }
    #endif
    
    while(!blogin){
        size = FTPClientControlSock->receive(rbuf, sizeof(rbuf));
        if(size > 0){
        #ifdef DEBUG
            printf("Received message from server: %s\r\n", rbuf);
        #endif
            if (!strncmp(rbuf, "220", 3)){
                printf("%s\r\n", rbuf);
                sprintf(sbuf, "user %s\r\n", id);             
                FTPClientControlSock->send(sbuf, strlen(sbuf));
            }
            else if (!strncmp(rbuf, "331", 3)){
                sprintf(sbuf, "pass %s\r\n", pass);             
                FTPClientControlSock->send(sbuf, strlen(sbuf));
            }
            else if (!strncmp(rbuf, "230", 3)){
                blogin = true;
            }
            else{
                blogin = true;
            }
        }  
    }
    return 1;
}
//*/
/*
bool FTPClient::open(char* ip, int port, char* id, char* pass)
{    
    printf("Inside Open");
    
    FTPClientControlSock = new TCPSocketConnection;
    FTPClientDataSock = new TCPSocketConnection;
    
    #if 0
    do{
        FTPClientControlSock->connect(ip, port);
    }while(!FTPClientControlSock->is_connected());
    #endif
    #if 1
    while (FTPClientControlSock->connect(ip, port) < 0) {
    #ifdef DEBUG
        printf("Unable to connect to (%s) on port (%d)\r\n", ip, port);
    #endif
        wait(1);
    }
    #endif
    
    while(!blogin){
        size = FTPClientControlSock->receive(rbuf, sizeof(rbuf));
        if(size > 0){
        #ifdef DEBUG
            printf("Received message from server: %s\r\n", rbuf);
        #endif
            if (!strncmp(rbuf, "220", 3)){
                printf("%s\r\n", rbuf);
                sprintf(sbuf, "user %s\r\n", id);             
                FTPClientControlSock->send(sbuf, strlen(sbuf));
            }
            else if (!strncmp(rbuf, "331", 3)){
                sprintf(sbuf, "pass %s\r\n", pass);             
                FTPClientControlSock->send(sbuf, strlen(sbuf));
            }
            else if (!strncmp(rbuf, "230", 3)){
                blogin = true;
            }
            else{
                blogin = true;
            }
        }  
    }
    return 1;
}
*/
bool FTPClient::getfile(char* myfilename, char* filename){
    
    if(blogin){
              
        sprintf(sbuf, "pasv\r\n");             
        FTPClientControlSock->send(sbuf, strlen(sbuf));
        
        while(!brfileflag){
            size = FTPClientControlSock->receive(rbuf, sizeof(rbuf));
            if(size > 0){
            #ifdef DEBUG
                printf("Received message from server: %s\r\n", rbuf);
            #endif
                if (!strncmp(rbuf, "150", 3)){
                    fp = fopen(myfilename, "w");
                #ifdef DEBUG
                    printf("myfilename : %s\r\n", myfilename); 
                #endif
                    while(true){
                        memset(rbuf, 0, sizeof(rbuf)); 
                        remain_datasize = FTPClientDataSock->receive(rbuf, sizeof(rbuf));
                    #ifdef DEBUG
                        printf("remain_datasize : %d\r\n", remain_datasize);
                    #endif
                        if(remain_datasize>0){
                            for (i = 0; i < remain_datasize; i++) {
                                //printf("%c", rbuf[i]);
                                fprintf(fp, "%c", rbuf[i]);
                            }
                        #ifdef DEBUG
                            printf("#");
                        #endif
                        }
                        else{
                            brfileflag = true;
                            fclose(fp);
                            FTPClientDataSock->close();
                            break;
                        }
                    }
                }
                else if (!strncmp(rbuf, "227", 3)){
                    pportc(rbuf); 
                    
                #if 1
                    while (FTPClientDataSock->connect(ftpServer_data_ip_addr_str, remote_port) < 0) {
                    #ifdef DEBUG
                        printf("Unable to connect to (%s) on port (%d)\r\n", ftpServer_data_ip_addr_str, remote_port);
                    #endif
                        wait(1);
                    }
                #endif
                    
                #if 0
                    do{
                        FTPClientDataSock->connect(ftpServer_data_ip_addr_str, remote_port);
                    }while(!FTPClientDataSock->is_connected());    
                #endif
                    sprintf(sbuf, "retr %s\r\n", filename);             
                    FTPClientControlSock->send(sbuf, strlen(sbuf));  
                }
            }  
        }
        brfileflag = false;
        return 1;
    }
    else return 0;
}
bool FTPClient::putfile(char* myfilename, char* filename){
    
    if(blogin){
        
        sprintf(sbuf, "pasv\r\n");             
        FTPClientControlSock->send(sbuf, strlen(sbuf));
        
        while(!bsfileflag){
            size = FTPClientControlSock->receive(rbuf, sizeof(rbuf));
            if(size > 0){
            #ifdef DEBUG
                printf("Received message from server: %s\r\n", rbuf);
            #endif
                if (!strncmp(rbuf, "150", 3)){
                    fp = fopen(myfilename, "r"); 
                    fseek(fp, 0, SEEK_END);            // seek to end of file
                    remain_filesize = ftell(fp);       // get current file pointer
                    fseek(fp, 0, SEEK_SET);            // seek back to beginning of file  
                    do{
                        memset(sbuf, 0, sizeof(sbuf));
                        if(remain_filesize > MAX_SS)
                            send_byte = MAX_SS;
                        else
                            send_byte = remain_filesize;
                        fread (sbuf, 1, send_byte, fp);
                        FTPClientDataSock->send(sbuf, send_byte);
                        remain_filesize -= send_byte;
                    #ifdef DEBUG
                        printf("#");
                    #endif
                    }while(remain_filesize!=0);
                    fclose(fp); 
                    bsfileflag = true;
                    FTPClientDataSock->close();
                    break;
                }
                else if (!strncmp(rbuf, "227", 3)){
                    pportc(rbuf); 
                #if 0
                    do{
                        FTPClientDataSock->connect(ftpServer_data_ip_addr_str, remote_port);
                    }while(!FTPClientDataSock->is_connected());  
                #endif
                    
                #if 1
                    while (FTPClientDataSock->connect(ftpServer_data_ip_addr_str, remote_port) < 0) {
                    #ifdef DEBUG
                        printf("Unable to connect to (%s) on port (%d)\r\n", ftpServer_data_ip_addr_str, remote_port);
                    #endif
                        wait(1);
                    }
                #endif  
                    sprintf(sbuf, "stor %s\r\n", filename);             
                    FTPClientControlSock->send(sbuf, strlen(sbuf));  
                }
            }  
        }
        bsfileflag = false;
        return 1;
    }
    else return 0;
}
bool FTPClient::dir(){
    
    if(blogin){
    
        sprintf(sbuf, "pasv\r\n");             
        FTPClientControlSock->send(sbuf, strlen(sbuf));
        
        while(!bdirflag){
            size = FTPClientControlSock->receive(rbuf, sizeof(rbuf));
            if(size > 0){
            #ifdef DEBUG
                printf("Received message from server: %s\r\n", rbuf);
            #endif
                if (!strncmp(rbuf, "150", 3)){
                    while(true){
                        memset(rbuf, 0, sizeof(rbuf));
                        size = FTPClientDataSock->receive(rbuf, sizeof(rbuf));
                        rbuf[size] = '\0';
                        if(size>0){
                            printf("%s", rbuf);
                        }
                        else{
                            bdirflag = true;
                            FTPClientDataSock->close();
                            break;
                        }
                    }  
                }
                else if (!strncmp(rbuf, "227", 3)){
                    pportc(rbuf); 
                #if 0
                    do{
                        FTPClientDataSock->connect(ftpServer_data_ip_addr_str, remote_port);
                    }while(!FTPClientDataSock->is_connected());   
                #endif
                #if 1
                    while (FTPClientDataSock->connect(ftpServer_data_ip_addr_str, remote_port) < 0) {
                    #ifdef DEBUG
                        printf("Unable to connect to (%s) on port (%d)\r\n", ftpServer_data_ip_addr_str, remote_port);
                    #endif
                        wait(1);
                    }
                #endif   
                    sprintf(sbuf, "list\r\n");             
                    FTPClientControlSock->send(sbuf, strlen(sbuf));  
                }
            }  
        }
        bdirflag = false;
        return 1;
    }
    else return 0;
}

bool FTPClient::ls(){
    
    if(blogin){
    
        sprintf(sbuf, "pasv\r\n");             
        FTPClientControlSock->send(sbuf, strlen(sbuf));
        
        while(!blsflag){
            size = FTPClientControlSock->receive(rbuf, sizeof(rbuf));
            if(size > 0){
            #ifdef DEBUG
                printf("Received message from server: %s\r\n", rbuf);
            #endif
                if (!strncmp(rbuf, "150", 3)){
                    while(true){
                        memset(rbuf, 0, sizeof(rbuf));
                        size = FTPClientDataSock->receive(rbuf, sizeof(rbuf));
                        rbuf[size] = '\0';
                        if(size>0){
                            printf("%s", rbuf);
                        }
                        else{
                            blsflag = true;
                            FTPClientDataSock->close();
                            break;
                        }
                    }  
                }
                else if (!strncmp(rbuf, "227", 3)){
                    pportc(rbuf); 
                #if 0
                    do{
                        FTPClientDataSock->connect(ftpServer_data_ip_addr_str, remote_port);
                    }while(!FTPClientDataSock->is_connected());   
                #endif
                #if 1
                    while (FTPClientDataSock->connect(ftpServer_data_ip_addr_str, remote_port) < 0) {
                    #ifdef DEBUG
                        printf("Unable to connect to (%s) on port (%d)\r\n", ftpServer_data_ip_addr_str, remote_port);
                    #endif
                        wait(1);
                    }
                #endif   
                    sprintf(sbuf, "nlst\r\n");             
                    FTPClientControlSock->send(sbuf, strlen(sbuf));  
                }
            }  
        }
        blsflag = false;
        return 1;
    }
    else return 0;
}

bool FTPClient::fdelete(char* filename){
    
    if(blogin){
    
        sprintf(sbuf, "dele %s\r\n", filename);             
        FTPClientControlSock->send(sbuf, strlen(sbuf));
        
        while(!bfdeleteflag){
            size = FTPClientControlSock->receive(rbuf, sizeof(rbuf));
            if(size > 0){
            #ifdef DEBUG
                printf("Received message from server: %s\r\n", rbuf);
            #endif
                if (!strncmp(rbuf, "250", 3)){
                    bfdeleteflag = true;
                }
                else {
                    return 0;
                }
            }  
        }
        bfdeleteflag = false;
        return 1;
    }
    else return 0;
}
bool FTPClient::mkdir(char* dirname){
    
    if(blogin){
    
        sprintf(sbuf, "xmkd %s\r\n", dirname);             
        FTPClientControlSock->send(sbuf, strlen(sbuf));
        
        while(!bmkdirflag){
            size = FTPClientControlSock->receive(rbuf, sizeof(rbuf));
            if(size > 0){
            #ifdef DEBUG
                printf("Received message from server: %s\r\n", rbuf);
            #endif
                if (!strncmp(rbuf, "257", 3)){
                    bmkdirflag = true;
                }
                else {
                    return 0;
                }
            }  
        }
        bmkdirflag = false;
        return 1;
    }
    else return 0;
}
bool FTPClient::cd(char* dirname){
    
    if(blogin){
    
        sprintf(sbuf, "cwd %s\r\n", dirname);             
        FTPClientControlSock->send(sbuf, strlen(sbuf));
        
        while(!bcdflag){
            size = FTPClientControlSock->receive(rbuf, sizeof(rbuf));
            if(size > 0){
            #ifdef DEBUG
                printf("Received message from server: %s\r\n", rbuf);
            #endif
                if (!strncmp(rbuf, "250", 3)){
                    bcdflag = true;
                }
                else {
                    return 0;
                }
            }  
        }
        bcdflag = false;
        return 1;
    }
    else return 0;
}
bool FTPClient::quit(){
    
    if(blogin){
    
        sprintf(sbuf, "quit \r\n");             
        FTPClientControlSock->send(sbuf, strlen(sbuf));
        
        while(!bquitflag){
            size = FTPClientControlSock->receive(rbuf, sizeof(rbuf));
            if(size > 0){
            #ifdef DEBUG
                printf("Received message from server: %s\r\n", rbuf);
            #endif
                if (!strncmp(rbuf, "250", 3)){
                    printf("%s\r\n", rbuf);
                    bquitflag = true;
                }
                else {
                    return 0;
                }
            }  
        }
        
        bquitflag = false;
        blogin = false;
        delete FTPClientControlSock;
        delete FTPClientDataSock;
        
        return 1;
    }
    else return 0;
}
int FTPClient::pportc(char * arg)
{
    char* tok=0;
    
    strtok(arg,"(");
    for (i = 0; i < 4; i++)
    {
        if(i==0) tok = strtok(NULL,",\r\n");
        else     tok = strtok(NULL,",");
        ftpServer_data_ip_addr[i] = (uint8_t)atoi(tok);
        if (!tok){
        #ifndef DEBUG
            printf("bad pport : %s\r\n", arg);
        #endif
            return -1;
        }
    }
    remote_port = 0;
    for (i = 0; i < 2; i++){
        tok = strtok(NULL,",\r\n");
        remote_port <<= 8;
        remote_port += atoi(tok);
        if (!tok){
        #ifdef DEBUG
            printf("bad pport : %s\r\n", arg);
        #endif
            return -1;
        }
    }
    sprintf(ftpServer_data_ip_addr_str, "%d.%d.%d.%d", ftpServer_data_ip_addr[0], ftpServer_data_ip_addr[1], ftpServer_data_ip_addr[2], ftpServer_data_ip_addr[3]);
    return 0;
}




