//
//  Definitions_32.h
//
//
//  Created by Conor Russomanno, Luke Travis, and Joel Murphy. Summer 2013.
//  Modified by Joel Murphy, Summer 2014
//  Joel Added Daisy Functionality Fall 2014
//

#ifndef _____OpenBCI_32bit_Library_Definitions_h
#define _____OpenBCI_32bit_Library_Definitions_h

// The default baud rate
#define OPENBCI_BAUD_RATE 115200

// File transmissions
#define OPENBCI_BOP 'A' // Begining of stream packet
#define OPENBCI_EOP_STND_ACCEL          0xC0 // End of standard stream packet
#define OPENBCI_EOP_STND_RAW_AUX        0xC1 // End of stream packet with raw packet
#define OPENBCI_EOP_USER_DEFINED        0xC2 // End of stream packet, user defined
#define OPENBCI_EOP_ACCEL_TIME_SET      0xC3 // End of time sync up with accel stream packet
#define OPENBCI_EOP_ACCEL_TIME_SYNCED   0xC4 // End of time synced stream packet
#define OPENBCI_EOP_RAW_AUX_TIME_SET    0xC5 // End of time sync up stream packet
#define OPENBCI_EOP_RAW_AUX_TIME_SYNCED 0xC6 // End of time synced stream packet

//PIN CONNECTIONS
/*
// MBED: pin definitions are in PlatformDefs.h
#define ADS_DRDY        9   // ADS data ready pin
#define ADS_RST         4   // ADS reset pin
#define BOARD_ADS       8   // ADS chip select
#define DAISY_ADS       3   // ADS Daisy chip select
#define BOTH_ADS        5   // Slave Select Both ADS chips
#define SD_SS           2   // SD card chip select
#define LIS3DH_SS       1   // LIS3DH chip select
#define LIS3DH_DRDY     0   // LIS3DH data ready pin
#define OPENBCI_PIN_LED 11
#define OPENBCI_PIN_PGC 12
*/
#define BOTH_ADS        5   // Slave Select Both ADS chips

//ADS1299 SPI Command Definition Byte Assignments
#define _WAKEUP 0x02 // Wake-up from standby mode
#define _STANDBY 0x04 // Enter Standby mode
#define _RESET 0x06 // Reset the device registers to default
#define _START 0x08 // Start and restart (synchronize) conversions
#define _STOP 0x0A // Stop conversion
#define _RDATAC 0x10 // Enable Read Data Continuous mode (default mode at power-up)
#define _SDATAC 0x11 // Stop Read Data Continuous mode
#define _RDATA 0x12 // Read data by command supports multiple read back

//ASD1299 Register Addresses
#define ADS_ID  0x3E    // product ID for ADS1299
#define ID_REG  0x00    // this register contains ADS_ID
#define CONFIG1 0x01
#define CONFIG2 0x02
#define CONFIG3 0x03
#define LOFF 0x04
#define CH1SET 0x05
#define CH2SET 0x06
#define CH3SET 0x07
#define CH4SET 0x08
#define CH5SET 0x09
#define CH6SET 0x0A
#define CH7SET 0x0B
#define CH8SET 0x0C
#define BIAS_SENSP 0x0D
#define BIAS_SENSN 0x0E
#define LOFF_SENSP 0x0F
#define LOFF_SENSN 0x10
#define LOFF_FLIP 0x11
#define LOFF_STATP 0x12
#define LOFF_STATN 0x13
//#define GPIO 0x14  // MBED: interfere with STM32 library
static const int GPIO = 0x14;
#define MISC1 0x15
#define MISC2 0x16
#define CONFIG4 0x17

#define OUTPUT_NOTHING (0)  // quiet
#define OUTPUT_8_CHAN (1)   // not using Daisy module
#define OUTPUT_16_CHAN (2)  // using Daisy module
#define ON_BOARD    (BOARD_ADS)           // slave address for on board ADS
#define ON_DAISY    (DAISY_ADS)             // slave address for daisy ADS
// CHANNEL SETTINGS 
#define POWER_DOWN      (0)
#define GAIN_SET        (1)
#define INPUT_TYPE_SET  (2)
#define BIAS_SET        (3)
#define SRB2_SET        (4)
#define SRB1_SET        (5)
#define YES         (0x01)
#define NO          (0x00)

//gainCode choices
#define ADS_GAIN01 (0b00000000) // 0x00
#define ADS_GAIN02 (0b00010000) // 0x10
#define ADS_GAIN04 (0b00100000) // 0x20
#define ADS_GAIN06 (0b00110000) // 0x30
#define ADS_GAIN08 (0b01000000) // 0x40
#define ADS_GAIN12 (0b01010000) // 0x50
#define ADS_GAIN24 (0b01100000) // 0x60

//inputType choices
#define ADSINPUT_NORMAL     (0b00000000)
#define ADSINPUT_SHORTED    (0b00000001)
#define ADSINPUT_BIAS_MEAS  (0b00000010)
#define ADSINPUT_MVDD       (0b00000011)
#define ADSINPUT_TEMP       (0b00000100)
#define ADSINPUT_TESTSIG    (0b00000101)
#define ADSINPUT_BIAS_DRP   (0b00000110)
#define ADSINPUT_BIAL_DRN   (0b00000111)

//test signal choices...ADS1299 datasheet page 41
#define ADSTESTSIG_AMP_1X (0b00000000)
#define ADSTESTSIG_AMP_2X (0b00000100)
#define ADSTESTSIG_PULSE_SLOW (0b00000000)
#define ADSTESTSIG_PULSE_FAST (0b00000001)
#define ADSTESTSIG_DCSIG (0b00000011)
#define ADSTESTSIG_NOCHANGE (0b11111111)

//Lead-off signal choices
#define LOFF_MAG_6NA        (0b00000000)
#define LOFF_MAG_24NA       (0b00000100)
#define LOFF_MAG_6UA        (0b00001000)
#define LOFF_MAG_24UA       (0b00001100)
#define LOFF_FREQ_DC        (0b00000000)
#define LOFF_FREQ_7p8HZ     (0b00000001)
#define LOFF_FREQ_31p2HZ    (0b00000010)
#define LOFF_FREQ_FS_4      (0b00000011)
#define PCHAN (0)
#define NCHAN (1)
#define OFF (0)
#define ON (1)

// used for channel settings
#define ACTIVATE_SHORTED (2)
#define ACTIVATE (1)
#define DEACTIVATE (0)

#define PCKT_START 0xA0 // prefix for data packet error checking
#define PCKT_END 0xC0   // postfix for data packet error checking

// daisy module
#define CLK_EN  5

//LIS3DH
//#define READ_REG      0x80 // MBED: interfere with STM32 library
static const int READ_REG = 0x80; 

#define READ_MULTI      0x40

#define STATUS_REG_AUX  0x07    // axis over-run and data available flags (see 0x27)
#define OUT_ADC1_L      0x08    //
#define OUT_ADC1_H      0x09    //
#define OUT_ADC2_L      0x0A    //  ADC input values (check DS)
#define OUT_ADC2_H      0x0B    //
#define OUT_ADC3_L      0x0C    //
#define OUT_ADC3_H      0x0D    //
#define INT_COUNTER_REG 0x0E    // ??
#define WHO_AM_I        0x0F    // DEVICE ID 0x33
#define TMP_CFG_REG     0x1F    // ADC enable (0x80) Temperature sensor enable (0x40)
#define CTRL_REG1       0x20    // Data Rate Power Mode X enable Y enable Z enable (on >0x10)
#define CTRL_REG2       0x21    // High Pass Filter Stuph
#define CTRL_REG3       0x22    // INT1 select register
#define CTRL_REG4       0x23    // Block update timing endian G-force resolution self test SPI pins
#define CTRL_REG5       0x24    // reboot FIFO enable latch 4D detection
#define CTRL_REG6       0x25    // ??
#define REFERENCE       0x26    // interrupt reference
#define STATUS_REG2     0x27    // axis overrun and availale flags (see 0x07)
#define OUT_X_L         0x28    //
#define OUT_X_H         0x29    //
#define OUT_Y_L         0x2A    //  tripple axis values (see 0x0A)
#define OUT_Y_H         0x2B    //
#define OUT_Z_L         0x2C    //
#define OUT_Z_H         0x2D    //
#define FIFO_CTRL_REG   0x2E    // FIFO mode trigger output pin select (?)
#define FIFO_SRC_REG    0x2F    // ??
#define INT1_CFG        0x30    // 6 degree control register
#define INT1_SOURCE     0x31    // axis threshold interrupt control
#define INT1_THS        0x32    // INT1 threshold
#define INT1_DURATION   0x33    // INT1 duration
#define CLICK_CFG       0x38    // click on axis
#define CLICK_SRC       0x39    // other click
#define CLICK_THS       0x3A    // more click
#define TIME_LIMIT      0x3B    // click related
#define TIME_LATENCY    0x3C    // and so on
#define TIME_WINDOW     0x3D    // contined click

#define SCALE_2G        0x00  //(b00000000) // +/- 2G sensitivity
#define SCALE_4G        0x10  //(b00010000) // +/- 4G sensitivity
#define SCALE_8G        0x20  //(b00100000) // +/- 8G sensitivity
#define SCALE_16G       0x30  //(b00110000) // +/- 16G sensitivity
#define RATE_1HZ        0x10  //(b00010000) // 1Hz sample rate in normal or low-power mode
#define RATE_10HZ       0x20  //(b00100000) // 10Hz sample rate in normal or low-power mode
#define RATE_25HZ       0x30  //(b00110000) // 25Hz sample rate in normal or low-power mode
#define RATE_50HZ       0x40  //(b01000000) // 50Hz sample rate in normal or low-power mode
#define RATE_100HZ      0x50  //(b01010000) // 100Hz sample rate in normal or low-power mode
#define RATE_200HZ      0x60  //(b01100000) // 200Hz sample rate in normal or low-power mode
#define RATE_400HZ      0x70  //(b01110000) // 400Hz sample rate in normal or low-power mode
#define RATE_1600HZ_LP  0x80  //(b10000000) // 1600Hz sample rate in low-power mode
#define RATE_1250HZ_N   0x90  //(b10010000) // 1250Hz sample rate in normal mode
#define RATE_5000HZ_LP  0x90  //(b10010000) // 5000Hz sample rate in low-power mode
#define ACCEL_AXIS_X    0x07 // x axis
#define ACCEL_AXIS_Y    0x08 // y axis
#define ACCEL_AXIS_Z    0x09 // z axis

// OPENBCI_COMMANDS
/** Turning channels off */
#define OPENBCI_CHANNEL_OFF_1 '1'
#define OPENBCI_CHANNEL_OFF_2 '2'
#define OPENBCI_CHANNEL_OFF_3 '3'
#define OPENBCI_CHANNEL_OFF_4 '4'
#define OPENBCI_CHANNEL_OFF_5 '5'
#define OPENBCI_CHANNEL_OFF_6 '6'
#define OPENBCI_CHANNEL_OFF_7 '7'
#define OPENBCI_CHANNEL_OFF_8 '8'
#define OPENBCI_CHANNEL_OFF_9 'q'
#define OPENBCI_CHANNEL_OFF_10 'w'
#define OPENBCI_CHANNEL_OFF_11 'e'
#define OPENBCI_CHANNEL_OFF_12 'r'
#define OPENBCI_CHANNEL_OFF_13 't'
#define OPENBCI_CHANNEL_OFF_14 'y'
#define OPENBCI_CHANNEL_OFF_15 'u'
#define OPENBCI_CHANNEL_OFF_16 'i'

/** Turn channels on */
#define OPENBCI_CHANNEL_ON_1 '!'
#define OPENBCI_CHANNEL_ON_2 '@'
#define OPENBCI_CHANNEL_ON_3 '#'
#define OPENBCI_CHANNEL_ON_4 '$'
#define OPENBCI_CHANNEL_ON_5 '%'
#define OPENBCI_CHANNEL_ON_6 '^'
#define OPENBCI_CHANNEL_ON_7 '&'
#define OPENBCI_CHANNEL_ON_8 '*'
#define OPENBCI_CHANNEL_ON_9 'Q'
#define OPENBCI_CHANNEL_ON_10 'W'
#define OPENBCI_CHANNEL_ON_11 'E'
#define OPENBCI_CHANNEL_ON_12 'R'
#define OPENBCI_CHANNEL_ON_13 'T'
#define OPENBCI_CHANNEL_ON_14 'Y'
#define OPENBCI_CHANNEL_ON_15 'U'
#define OPENBCI_CHANNEL_ON_16 'I'

/** Test Signal Control Commands
 * 1x - Voltage will be 1 * (VREFP - VREFN) / 2.4 mV
 * 2x - Voltage will be 2 * (VREFP - VREFN) / 2.4 mV
 */
#define OPENBCI_TEST_SIGNAL_CONNECT_TO_DC            'p'
#define OPENBCI_TEST_SIGNAL_CONNECT_TO_GROUND        '0'
#define OPENBCI_TEST_SIGNAL_CONNECT_TO_PULSE_1X_FAST '='
#define OPENBCI_TEST_SIGNAL_CONNECT_TO_PULSE_1X_SLOW '-'
#define OPENBCI_TEST_SIGNAL_CONNECT_TO_PULSE_2X_FAST ']'
#define OPENBCI_TEST_SIGNAL_CONNECT_TO_PULSE_2X_SLOW '['

/** Channel Setting Commands */
#define OPENBCI_CHANNEL_CMD_ADC_Normal      '0'
#define OPENBCI_CHANNEL_CMD_ADC_Shorted     '1'
#define OPENBCI_CHANNEL_CMD_ADC_BiasDRP     '6'
#define OPENBCI_CHANNEL_CMD_ADC_BiasDRN     '7'
#define OPENBCI_CHANNEL_CMD_ADC_BiasMethod  '2'
#define OPENBCI_CHANNEL_CMD_ADC_MVDD        '3'
#define OPENBCI_CHANNEL_CMD_ADC_Temp        '4'
#define OPENBCI_CHANNEL_CMD_ADC_TestSig     '5'
#define OPENBCI_CHANNEL_CMD_BIAS_INCLUDE    '1'
#define OPENBCI_CHANNEL_CMD_BIAS_REMOVE     '0'
#define OPENBCI_CHANNEL_CMD_CHANNEL_1       '1'
#define OPENBCI_CHANNEL_CMD_CHANNEL_2       '2'
#define OPENBCI_CHANNEL_CMD_CHANNEL_3       '3'
#define OPENBCI_CHANNEL_CMD_CHANNEL_4       '4'
#define OPENBCI_CHANNEL_CMD_CHANNEL_5       '5'
#define OPENBCI_CHANNEL_CMD_CHANNEL_6       '6'
#define OPENBCI_CHANNEL_CMD_CHANNEL_7       '7'
#define OPENBCI_CHANNEL_CMD_CHANNEL_8       '8'
#define OPENBCI_CHANNEL_CMD_CHANNEL_9       'Q'
#define OPENBCI_CHANNEL_CMD_CHANNEL_10      'W'
#define OPENBCI_CHANNEL_CMD_CHANNEL_11      'E'
#define OPENBCI_CHANNEL_CMD_CHANNEL_12      'R'
#define OPENBCI_CHANNEL_CMD_CHANNEL_13      'T'
#define OPENBCI_CHANNEL_CMD_CHANNEL_14      'Y'
#define OPENBCI_CHANNEL_CMD_CHANNEL_15      'U'
#define OPENBCI_CHANNEL_CMD_CHANNEL_16      'I'
#define OPENBCI_CHANNEL_CMD_GAIN_1          '0'
#define OPENBCI_CHANNEL_CMD_GAIN_2          '1'
#define OPENBCI_CHANNEL_CMD_GAIN_4          '2'
#define OPENBCI_CHANNEL_CMD_GAIN_6          '3'
#define OPENBCI_CHANNEL_CMD_GAIN_8          '4'
#define OPENBCI_CHANNEL_CMD_GAIN_12         '5'
#define OPENBCI_CHANNEL_CMD_GAIN_24         '6'
#define OPENBCI_CHANNEL_CMD_LATCH           'X'
#define OPENBCI_CHANNEL_CMD_POWER_OFF       '1'
#define OPENBCI_CHANNEL_CMD_POWER_ON        '0'
#define OPENBCI_CHANNEL_CMD_SET             'x'
#define OPENBCI_CHANNEL_CMD_SRB1_CONNECT    '1'
#define OPENBCI_CHANNEL_CMD_SRB1_DISCONNECT '0'
#define OPENBCI_CHANNEL_CMD_SRB2_CONNECT    '1'
#define OPENBCI_CHANNEL_CMD_SRB2_DISCONNECT '0'

/** Default Channel Settings */
#define OPENBCI_CHANNEL_DEFAULT_ALL_SET 'd'
#define OPENBCI_CHANNEL_DEFAULT_ALL_REPORT 'D'

/** LeadOff Impedance Commands */
#define OPENBCI_CHANNEL_IMPEDANCE_LATCH                'Z'
#define OPENBCI_CHANNEL_IMPEDANCE_SET                  'z'
#define OPENBCI_CHANNEL_IMPEDANCE_TEST_SIGNAL_APPLIED    '1'
#define OPENBCI_CHANNEL_IMPEDANCE_TEST_SIGNAL_APPLIED_NOT '0'

/** SD card Commands */
#define OPENBCI_SD_LOG_FOR_HOUR_1    'G'
#define OPENBCI_SD_LOG_FOR_HOUR_2    'H'
#define OPENBCI_SD_LOG_FOR_HOUR_4    'J'
#define OPENBCI_SD_LOG_FOR_HOUR_12   'K'
#define OPENBCI_SD_LOG_FOR_HOUR_24   'L'
#define OPENBCI_SD_LOG_FOR_MIN_5     'A'
#define OPENBCI_SD_LOG_FOR_MIN_15    'S'
#define OPENBCI_SD_LOG_FOR_MIN_30    'F'
#define OPENBCI_SD_LOG_FOR_SEC_14    'a'
#define OPENBCI_SD_LOG_STOP        'j'

/** Stream Data Commands */
#define OPENBCI_STREAM_START  'b'
#define OPENBCI_STREAM_STOP   's'

/** Miscellaneous */
#define OPENBCI_MISC_QUERY_REGISTER_SETTINGS '?'
#define OPENBCI_MISC_SOFT_RESET              'v'

/** 16 Channel Commands */
#define OPENBCI_CHANNEL_MAX_NUMBER_8    'c'
#define OPENBCI_CHANNEL_MAX_NUMBER_16   'C'

/** Set Packet Type */
#define OPENBCI_BOARD_MODE_SET '/'
#define OPENBCI_BOARD_MODE_DEFAULT '0'
#define OPENBCI_BOARD_MODE_DEBUG '1'
#define OPENBCI_BOARD_MODE_WIFI '2'
#define OPENBCI_BOARD_MODE_INPUT_ANALOG '3'
#define OPENBCI_BOARD_MODE_INPUT_DIGITAL '4'

/** Sync Clocks */
#define OPENBCI_TIME_SET '<'
#define OPENBCI_TIME_STOP '>'

/** Possible number of channels */
#define OPENBCI_NUMBER_OF_CHANNELS_DAISY 16
#define OPENBCI_NUMBER_OF_CHANNELS_DEFAULT 8

/** Helpful numbers */
#define OPENBCI_NUMBER_OF_BOARD_SETTINGS 1
#define OPENBCI_NUMBER_OF_CHANNEL_SETTINGS 6
#define OPENBCI_NUMBER_OF_LEAD_OFF_SETTINGS 2

/** Possible Sample Rates*/
#define OPENBCI_SAMPLE_RATE_125 125
#define OPENBCI_SAMPLE_RATE_250 250

/** Packet Size */
#define OPENBCI_PACKET_SIZE 33

/** Impedance Calculation Variables */
#define OPENBCI_LEAD_OFF_DRIVE_AMPS 0.000000006
#define OPENBCI_LEAD_OFF_FREQUENCY_HZ 31

/** Raw data packet types/codes */
#define OPENBCI_PACKET_TYPE_V3              0 // 0000
#define OPENBCI_PACKET_TYPE_TIME_SYNCED     1 // 0001
#define OPENBCI_PACKET_TYPE_TIME_SET        2 // 0010
#define OPENBCI_PACKET_TYPE_USER_DEFINED    3 // 0011
#define OPENBCI_PACKET_TYPE_RAW_AUX         4 // 0100

#define OPENBCI_TIME_OUT_MS_1 1
#define OPENBCI_TIME_OUT_MS_3 3

#define OPENBCI_NUMBER_OF_BYTES_SETTINGS_CHANNEL 9
#define OPENBCI_NUMBER_OF_BYTES_SETTINGS_LEAD_OFF 5

#define OPENBCI_NUMBER_OF_BYTES_AUX 6

#define OPENBCI_FIRMWARE_VERSION_V1 1
#define OPENBCI_FIRMWARE_VERSION_V2 1

#endif
