#include "mbed.h"
#include "rtos.h"
#include "hts221.h"
#include "LPS25H.h"

Serial pc(USBTX, USBRX);

#define NUMTHRDS 2
#define N 10
DigitalOut myled(D7);
Ticker t;
I2C i2c2(I2C_SDA, I2C_SCL);

float tempCelsius = 25.50;
float humi = 55;
int humiMax = 100;
char cmd[20];
char cmd2[20];
char s1[20];
char s11[20];
char s2[20];
char s22[20];
float tempArray[N];
float humArray[N];
float pressArray[N];
uint32_t seconds = 0, minutes=0, hours=0; 




LPS25H barometer(i2c2, LPS25H_V_CHIP_ADDR);
HTS221 humidity(I2C_SDA, I2C_SCL);


void adcISR();
void thread1 (void const *args );
void threadcomun (void const *args);

Thread* t1;
Thread* t2;





typedef struct {
      
      float tempVal ;
      float humVal;
      float pressVal;
    }message_t;
    
Mail<message_t, 10> mail_box;

void adcISR()
{
       message_t *message = mail_box.alloc();
       message->tempVal = tempCelsius;
       message->humVal = humi;
       message->pressVal = barometer.pressure();
       myled=1;
       mail_box.put(message);
       //Thread::wait(1000);
       
}
void thread1 (void const *args )
{
         
         pc.baud(115200);
         //pc.printf("Temperature,Humidity,Pressure\n\n");
   while(1) 
   {  
        
         osEvent evt = mail_box.get();
        if (evt.status == osEventMail) 
        { 
            for (unsigned int n=(N-1); n>0; n--) 
           { 
             tempArray[n]= tempArray[n-1];
             humArray[n]= humArray[n-1];
             pressArray[n]= pressArray[n-1];
           }
             message_t *message = (message_t*)evt.value.p;
             tempArray[0]= message->tempVal;
             humArray[0] = message->humVal;
             pressArray[0]= message->pressVal;
             
            
            // pc.printf("%4.2f,%3.1f,%6.1f\n\r", tempArray[N/2], humArray[N/2], pressArray[N/2]);
             
             mail_box.free(message); 
       }
    }    
}

void threadcomun (void const *args)
{
 int ret;
  int ret2;

         pc.baud(115200);
         pc.printf("Temperature,Humidity,Pressure\n\n");
         //while(cmd==NULL){cmd=getchar();}
         while(1){
         scanf("%s%s",&cmd,&cmd2);
        
         //pc.printf("YOU ENTERED: %s \n",cmd);
            strcpy (s1,cmd);
            strcpy (s11,cmd2);
            strcpy (s2,"READ");
            strcpy (s22,"ALL");
            ret = strncmp(s1,s2,20);
            ret = strncmp(s11,s22,20);
           
            if (ret==0 && ret2==0)
            {
             
               for (unsigned int n=0; n<N; n++)
                {
                  pc.printf("the element of %d is %4.2f\n\r ",n,tempArray[n]);
                  
                // wait(1.0);
               }
            }
            else
            {
                pc.printf("error re mlk:  %s\n",cmd);
             }
             }
 
 }
 char answer;
int main(void)
  { 
  
    puts("Loading... \n\n");
    t1 =  new Thread(thread1);
    t2 = new Thread(threadcomun);
     
     
   // Thread thread(thread1);
    //threadcomun();
    
    //Thread thread(threadcomun);
    t.attach(&adcISR,5); // timer of measurements 
    
    while(1) 
    {
       humidity.init();
       humidity.calib();
       humidity.ReadTempHumi(&tempCelsius, &humi);
       barometer.get();
       barometer.pressure();
       barometer.temperature();
       sleep();
       Thread::wait(200); // 200 ms NB 'Thread::wait(int d);' !!! d is in milliseconds! 
       myled = 0; // LED is OFF
       Thread::wait(100); // 100 ms
    }
      
  }
  










