/**********************************************************
**                  Soft253 Coursework                   **
**          BY: Alion Kovaci, Panagiotis Mitseas         **
**              Stefanos Aristeidou and Tengfei He       **
**********************************************************/
#include "mbed.h"
#include "rtos.h"
#include "hts221.h"
#include "LPS25H.h"
#include "time.h"
#include "stdio.h"
#include "stdlib.h"

Serial pc(USBTX, USBRX);

#define N 120 //Set constant array size
DigitalOut myled(D7);
Ticker t;
I2C i2c2(I2C_SDA, I2C_SCL);

float tempCelsius = 25.50;
float humi = 55;
int humiMax = 100;
char cmd[20];
char cmd2[20];
char cmdSet[20];
char cmdSet2[20];
char input1[20];
char input2[20];
char inputSet1[20];
char inputSet2[20];
char inputDel1[20];
char inputDel2[20];
char inputState1[20];
char inputState2[20];
char inputStateOFF1[20];
char inputStateOFF2[20];
float tempArray[N];
float humArray[N];
float pressArray[N];
 int sampleSpeed = 15;
uint32_t seconds = 0, minutes=0, hours=0; 

int counters = 0;
int res;
int res2;
int resSet1;
int resSet2;
int resState1;
int resState2;

LPS25H barometer(i2c2, LPS25H_V_CHIP_ADDR);
HTS221 humidity(I2C_SDA, I2C_SCL);


void adcISR();
void thread1 (void const *args );
void threadcomun (void const *args);

Thread* t1;
Thread* t2;




typedef struct {      
  float tempVal ;
  float humVal;
  float pressVal;
}message_t; //Set the variable for array element
    
Mail<message_t, 16> mail_box; //Array

/**************************************************
**The code above is use for declare the variables**
**           and functions                       **
**************************************************/

void adcISR()
{
   message_t *message = mail_box.alloc();
   message->tempVal = tempCelsius;
   message->humVal = humi;
   message->pressVal = barometer.pressure();
   //Assign values
   //Set light on when timer is running every 15s(Default)
    myled=1; 
   //Count how many records are
   if (counters < N) //If the count didnt reach maximum 120, keep count
   {
       counters= counters + 1;
   }
   else //else if count reaches more tha 120 , set to 120
   {
     counters = N;
   }  
   // Store data of message to the mail Box        
    mail_box.put(message);      
}

/**
thread for implementing the circular buffering (FIFO)
**/
void thread1 (void const *args )
{         
    pc.baud(115200);   //Serial com Speed
    while(1) 
    {          
        osEvent evt = mail_box.get();
        if (evt.status == osEventMail) 
        { 
            for (unsigned int n=(N-1); n>0; n--) 
            { 
                 tempArray[n]= tempArray[n-1];
                 humArray[n]= humArray[n-1];
                 pressArray[n]= pressArray[n-1];
            }
            message_t *message = (message_t*)evt.value.p;
            tempArray[0]= message->tempVal;
            humArray[0] = message->humVal;
            pressArray[0]= message->pressVal;   
             
             mail_box.free(message); 
       }
    }    
}

/**
thread for the serial comunication with Putty

**/
void threadComun (void const *args)
{  
    pc.baud(115200);
    pc.printf("Temperature,Humidity,Pressure\n");
    
    while(1)
    {
         pc.printf("Temperature,Humidity,Pressure Samples\n");
        scanf("%s%s",cmd,cmd2); //Read user input
        strcpy (input1,cmd);   //Input 1(Before the space)
      
        strcpy (input2,cmd2);   //Input 2 (After the space)
       
        res = strncmp(input1,"READ",20);  //Compare the first input with the word "READ"
        res2 = strncmp(input2,input2,20); //Compare the second input with the input (is always true) 
        int val = atoi(input2);     //Convert String to int
        if(val <= N && val >=1)    //check if the number of input is valid
        {
            if(res == 0 && res2 == 0)//If two values matches then execute
            {   
                
                for (unsigned int n = 0; n < val; n++) 
                {  //Get values from index 0 to val(user input) index
                  pc.printf("Sample %d : %4.2f, %6.1f ,%3.1f\n\r",n,
                            tempArray[n],pressArray[n],humArray[n]);
                }
            }
           
              
           
        }
        if(val > N )    //if the user input is more than 120 the show 120 samples
        {
            if(res == 0 && res2 == 0)//If two values matches then execute
            {   
                for (unsigned int n = 0; n < N; n++) 
                {  //show sample from 1 to 120
                  pc.printf("Sample %d : %4.2f, %6.1f ,%3.1f\n\r",n,
                            tempArray[n],pressArray[n],humArray[n]);
                }
            }
        }
         
        else 
            {
                res = strncmp(input1,"READ",20); // Compare the first input with the word "READ"
                res2 = strncmp(input2,"ALL",20); // Compare the second input with the word "ALL"
                //Compare values
               if (res == 0 && res2 == 0)
               {//If condition is true then print from sample 1 to 120.
               
                    for (unsigned int n = 0; n < N; n++)
                    {
                       pc.printf("Sample %d : %4.2f, %6.1f ,%3.1f\n\r",n,
                       tempArray[n],pressArray[n],humArray[n]);
                    }                        
                }
                else 
                {   
                    //Compare values 
                    res = strncmp(input1,"DELETE",20); // Compare the first input with the word "DELETE"
                    res2 = strncmp(input2,"ALL",20); // Compare the first input with the word "ALL"
                    if(res==0 && res2==0) //if match the execute
                    {
                        //Erase all elements, replace with 0
                        memset(tempArray, 0, sizeof tempArray);  
                        memset(humArray, 0, sizeof humArray);  
                        memset(pressArray, 0, sizeof pressArray);               
                        pc.printf("%d Elements deleted\n",N);
                        counters = 0;  //Reset count
                    }
                                
                }
                                               
            } 
            
           
            
        
        strcpy (inputDel1,cmd); // copy the input (cmd) to the variable inputDel1 
        strcpy (inputDel2,cmd2);  // copy the input (cmd2) to the variable inputDel2 
        resSet1 = strncmp(input1,"DELETE",20); // Compare the first input with the word "DELETE"
        resSet2 = strncmp(input2,inputDel2,20); // Compare the second input with its self (it is always same)
        int valDel = atoi(inputDel2);  //convert string to int    
        int startDel=(counters - valDel); // calculate the start index of deleting 
        if (valDel <=N && valDel >=1)
        {
            if(resSet1==0 && resSet2==0) //if the input are same with resSet1,2 execute
            {                   
                for (unsigned int n=startDel; n<counters; n++) //delete specific elements (set to "0")
                {
                    tempArray[n]=0.00; 
                    humArray[n]=0.00;
                    pressArray[n]=0.00;
                }
                pc.printf("Deleted %d records\n",valDel);
                counters = counters - valDel;
            }
        } 
        
        
        //Assign the input to other variables
        strcpy (inputSet1,cmd);   
        strcpy (inputSet2,cmd2);
        //Compare command
        resSet1 = strncmp(inputSet1,"SETT",20); // Compare the first input with the word "SETT"
        resSet2 = strncmp(inputSet2,inputSet2,20); // Compare the second input with its self
        int inputSpeed = atoi(inputSet2); // String to int
        if (inputSpeed <=60 && inputSpeed >=0.1) //if the input is valid execute
        {
            if (resSet1==0 && resSet2==0)
            {   
                //update the timer speed   
                sampleSpeed = inputSpeed;
                t.attach(&adcISR, sampleSpeed); 
                pc.printf("T UPDATED TO %d\n",sampleSpeed);
            }
         }
         //Assign the input to other variables
         strcpy (inputState1,cmd);  
         strcpy (inputState2,cmd2);
         resSet1 = strncmp(inputState1,"STATE",20); // Compare the first input with the word "STATE"
         resSet2 = strncmp(inputState2,"ON",20); // Compare the second input with the word "ON"
        if (resSet1==0 && resSet2==0)
        { 
           //set the timer  ON
            t.attach(&adcISR, sampleSpeed);  
            pc.printf("Sampling: ON\n"); 
                   
        }
        //Assign the input to other variables
         strcpy (inputStateOFF1,cmd);   
         strcpy (inputStateOFF2,cmd2);
         resState1 = strncmp(inputStateOFF1,"STATE",20); // Compare the first input with the word "STATE"
         resState2 = strncmp(inputStateOFF2,"OFF",20); // Compare the second input with the word "OFF"
        
        if (resState1==0 && resState2==0) //if are the same execute
        {    
            //set the timer off           
            t.detach(); 
            pc.printf("Sampling: OFF\n"); 
        }                
                
     }//while
}
 
 char answer;
 
int main(void)
{ 
    //Pre load
    puts("Loading... \n\n");
    humidity.powerMode(HTS221::POWER_SHUTDOWN); //Low-power mode
    t1 = new Thread(thread1);
    t2 = new Thread(threadComun);
    t.attach(&adcISR,sampleSpeed); // timer of measurements 
    
    humidity.powerMode(HTS221::POWER_NORMAL);
    //Normal mode, which refers to normal power cosumption mode
    while(1) 
    {
       //read the sensor data
       humidity.init();
       humidity.calib();
       humidity.ReadTempHumi(&tempCelsius, &humi);
       barometer.get();
       barometer.pressure();
       barometer.temperature();
       sleep(); //if timer is off the sleep 
       Thread::wait(200); // 200 ms NB 'Thread::wait(int d);' !!! d is in milliseconds! 
       myled = 0; // LED is OFF
       Thread::wait(100); // 100 ms
    }
  
}