#ifndef __COOS_H
#define __COOS_H

//##########################################################
// Common includes 
//##########################################################

#include <setjmp.h>

//##########################################################
// def & enum
//##########################################################
enum{
    MAX_TASKS       =    8,
    STOP            =   -2
};

#define DELAY(__delay) if (!setjmp(COOS_task_context[COOS_task_no])) {longjmp(COOS_main_context, __delay+1);} else

//##########################################################
// var
//##########################################################

extern jmp_buf  COOS_main_context;
extern jmp_buf  COOS_task_context[MAX_TASKS];    /* store environment for all tasks */
extern volatile int COOS_task_no;

//##########################################################
// func
//##########################################################

void shutdown_task(int task_No);
void wake_up_task(int task_No);

#endif /* __COOS_H */
