#include "mbed.h"
#include "TextLCD.h"
#include "button_value.h"
#include <map>
#include <string.h>
#include <math.h>

// Define screen
TextLCD lcd(PA_8, PA_9, PC_7, PB_6, PA_7, PA_6, PA_5); // RS, RW, E, D4-D7
 
// Define Bus In for Buttons (Do, Re, Mi, Fa, Sol, La, Si, Do)
BusIn Bus_In(PA_0, PA_1, PA_4, PB_0, PA_10, PB_3, PB_5, PB_4);

// Define the PWM speaker
PwmOut speaker(PB_10);
    
//Define variables for sound
struct  NoteReference {
    char    name[4];
    int     mask;
    double  frequency;
    double  add[4];
    };
NoteReference   noteReference[8] = {   {"Do", 0x1, 262.0, {0.0, -1.0, -1.5, -3.0}},
                                                {"Re", 0x2, 294.0, {0.0, -1.0, -1.0, -3.0 }},
                                                {"Mi", 0x4, 330.0, {0.0, -1.0, -1.5, -3.0}},
                                                {"Fa", 0x8, 349.0, {0.0, 0.5, -1.0, 2.0}},
                                                {"Sol", 0x10, 392.0, {0.0, 0.0, 0.0, 0.0}},
                                                {"La", 0x20, 440.0, {0.0, 0.0, 0.0, 0.0}},
                                                {"Si", 0x40, 494.0, {0.0, 0.0, -1.0, -1.0}},
                                                {"Do", 0x80, 523.0, {0.0, 0.0, 0.0, 0.0}}
                                            };
volatile int    state_buttons = 0;
volatile int    gamme = 0;

void print_note(char *str)
{
//    lcd.cls();
  //  wait(0.000040f);
    lcd.printf("%s", str);
}


DigitalOut led1(LED1);

void    refresh_state_button()
{
   //printf("refresh_state_button \n");
   state_buttons = Bus_In & Bus_In.mask(); // read the bus and mask out bits not being used    
   //printf("state_button [ %d ]\n", state_buttons);
}

void        play_music(int notes, double frequency)
{
   speaker.period(1.0 / frequency);            
   while (state_buttons == notes) {
     refresh_state_button();
   }
}

void        check_buttons()
{
    double   frequency = 0.0;
    int      i = 0;
    char     bufferOutput[30] = "";
    
    if (state_buttons == 0xFF)
    {
        speaker = 0;
        lcd.cls();
    }
    else {
        while (i < 8)
        {
            if (!(state_buttons & noteReference[i].mask)) {
                frequency += noteReference[i].frequency * pow(2.0, gamme) + noteReference[i].add[gamme];
                strcat(bufferOutput, noteReference[i].name);
                strcat(bufferOutput, " ");
            }
            i++;
        }
        speaker = 0.5;
        print_note(bufferOutput);
        play_music(state_buttons, frequency);
    }
}

// TODO: perios of notes with ID
// TODO: implement new 4 buttons
// TODO: link new 2 buttons + implementation
// TODO: deal with gamme

// TODO: PB with DO RE on the screen (board crashes)

int main()
{
    //lcd.printf("%s\n", "CS435 Piano");
    //wait(3);

    while (true) {
        //printf("loop\n");
        led1 = !led1;
        refresh_state_button();
        check_buttons();
        wait(0.1);
        lcd.cls();
    }
}
