#include <string>
#include <vector>
#include <memory>

class Menu {
    public:
        //methods
        int select();
        void draw();
        void update_selection();
        void set_active();
        void add_child(Menu* child);
        //static methods
        static void go_back();
        static void clear_cursor();
        static void draw_cursor();
        static void update_cursor();
        static std::string run();
        
        //members
        std::string name;
        std::string label;
        Menu * parent;
        std::vector<Menu*> entries;
        void (*onClick) ();
       
        //constructors
        Menu (std::string name="",
              std::string label="",
              void (*onClick)()=NULL);
        
    private:
        static Menu* active_menu;
        static int selected_entry;
    };


