#include "mbed.h"
#include "stdio.h"
#include "uLCD_4DGL.h"
#include "menu.h"
#include "RPG.h"
#include "CursorController.h"
#include "math.h"
#include "MMA8452.h"
#include "SaveFile.h"
#include "stdlib.h"
#include "SDFileSystem.h"

uLCD_4DGL uLCD(p13, p14, p15); // serial tx, serial rx, reset pin;
SDFileSystem sd(p5, p6, p7, p8, "sd");
Serial pc(USBTX, USBRX);

BusIn bus1(p21, p22);
BusIn bus2(p23, p18);
BusIn bus3(p17, p16);
int color;

DigitalOut connectionLed(LED1);

double x, y, z, accMag;

MMA8452 acc(p28, p27, 100000);

CursorController c;
//intialize knobs
AnalogIn left_pot(p20);
AnalogIn right_pot(p19);
InterruptIn push_button(p25, PullUp);

volatile bool pushed = false;

void button_cb() {
    pushed = true;
}

std::string endLabel;
int game_mode = 1;

DigitalOut led1(LED1);
DigitalOut led4(LED4);

void new_game() 
{
    uLCD.background_color(BLACK);  
    uLCD.cls();
}

void load_game(std::string fileName)
{
    uLCD.cls();
    std::string base = "/sd/";
    read_image((base.append(fileName)).c_str());
}

void save_game()
{
    save_image();
}

int main()
{
    uLCD.cls();
    uLCD.baudrate(3000000); //jack up baud rate to max for fast display
//    
    int lastX, lastY, X, Y;
    lastX = c.getX(); lastY = c.getY();
    wait(.5);
    
    bus1.mode(PullUp);
    bus2.mode(PullUp);
    bus3.mode(PullUp);

    
    while(true) {
        if (game_mode == 0) {
            while (1) {
                
                X = c.getX(); Y = c.getY();
                uLCD.line(lastX, lastY, X, Y, color);
                //printf("Drew a line from (%d,%d) to (%d, %d)\r\n", lastX, lastY, X, Y);
                lastX = X; lastY = Y;


                // 5.  read the dip switches
                // 6.  bit math that into three color values (top 2 bits of each color)
                // 7.  update the color variables
                
                color = 0;
                color |= (bus1 * 64);
                color |= (bus2 * 64 * 2*2*2*2*2*2*2*2);
                color |= (bus3 * 64 * 2*2*2*2*2*2*2*2 * 2*2*2*2*2*2*2*2);
//                pc.printf("color: %x\r\n", color);
        
                // 8.  read the IMU
                // 9.  decide if the acceleration magnitude is great enough to clear
                //     todo: debounce???
                // 10. if so, clear LCD screen
                acc.readXYZGravity(&x,&y,&z);
                accMag = sqrt(x*x + y*y + z*z);
                if(accMag > 2.5) {
                    uLCD.cls();
                }
                
                if (pushed) {
                    wait(0.5);
                    pushed = false;
                    // write image to SD card
                    save_game();
                    game_mode = 1;
                    break;
                }
            }
        } else {
            uLCD.background_color(BLACK);
            uLCD.cls();
            pc.printf("Initializing menu...\r\n");
            push_button.fall(&button_cb);
            Menu* main_menu = new Menu();
            main_menu->add_child(new Menu("END", "Start New"));
            main_menu->add_child(new Menu("menu1", "Load Picture"));
            // connect to file system
            // build menu tree
            main_menu->entries[1]->add_child(new Menu("sm1", "Go Back", Menu::go_back));
            char buffer [9000];
            for (int i = 0; i < get_highest_number(read_file_names()); i++) {
                sprintf(buffer, "%d", i);
                pc.printf("adding file %d", i);
                std::string filename = buffer;
                main_menu->entries[1]->add_child(new Menu("END", buffer));            
            }
            main_menu->set_active();
            endLabel = Menu::run();  
            pc.printf("menu terminated with message: \r\n");
            pc.printf(endLabel.c_str());
            pc.printf("\r\n");
            
            if (endLabel == "Start New") {
                new_game();
            }
            else {
                load_game(endLabel);
            }
            game_mode = 0; //start game
        }
    }
}
