#include <vector>
#include <string>


#include "mbed.h"
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"

#include "SaveFile.h"

extern uLCD_4DGL uLCD;
extern SDFileSystem sd;

int save_image() {
    char fn[100];
    sprintf(fn, "/sd/%d", get_highest_number(read_file_names()));
    FILE *fp = fopen(fn, "wb");
    if (fp == NULL) {
        printf("Couldn't open file");
        return -1;
    }
    printf("Grabbing Pixel Values!");
    int pix_buf[128];
    for (int i = 0; i < 128; i++) {
        for (int j = 0; j < 128; j++) {
            pix_buf[j] = color_convert(uLCD.read_pixel(i,j));
            //printf("Pixel Color is 0x%08x\r\n", color_convert(pix_buf[j]));
        }
        //printf("Writing line %d", i);
        fwrite(pix_buf, sizeof(int), 128, fp);
    }
    fclose(fp);  
    return 0;
    }

int read_image(const char* fn) {
    FILE * fp = fopen(fn, "rb");
    if (fp == NULL)
        return -1;
    int pix = 0;
    for (int i = 0; i < 128; i++) {
        for (int j = 0; j < 128; j++) {
            fread(&pix, sizeof(int), 1, fp);
            uLCD.pixel(i, j, pix);
        }
    }

 return 0;
 }

int color_convert(int pixel) {
    int red_mask = 0xF800;
    int green_mask = 0x7E0;
    int blue_mask = 0x1F;
    int red_value = (pixel & red_mask) >> 11;
    int green_value = (pixel & green_mask) >> 5;
    int blue_value = (pixel & blue_mask);
    // Expand to 8-bit values.
    int red   = red_value << 3;
    int green = green_value << 2;
    int blue  = blue_value << 3;
    int color = (red << 16) | (green << 8) | (blue);
    return color;
    }
std::vector<std::string> read_file_names()
{
    char* dir = "/sd/";
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
  //read all directory and file names in current directory into filename vector
    std::vector<std::string> filenames;
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
    closedir(dp);
    return filenames;
}
int get_highest_number (std::vector<std::string> filenames) {
    return filenames.size(); 
    }
