#include "mbed.h"
#include "uLCD_4DGL.h"

#include <string>
#include <vector>

#include "menu.h"

//devices declared in main
extern AnalogIn left_pot;
extern AnalogIn right_pot;
extern uLCD_4DGL uLCD;
extern bool pushed;


//constructors
Menu::Menu (std::string name,
            std::string label,
            void (*onClick)()) {
                this->name = name;
                this->label = label;
                this->parent = parent;
                this->onClick = onClick;                   
                }
    
//static initialization
int Menu::selected_entry = 0;
Menu* Menu::active_menu = NULL;
    
void Menu::go_back(){
    active_menu = active_menu->parent;
    active_menu->draw();
    active_menu->draw_cursor();
    }
void Menu::set_active(){
    active_menu = this;
    }

void Menu::draw(){
    uLCD.cls();
    uLCD.color(GREEN);
    uLCD.locate(0,0);
    //print each of the sub-entries
    for(int i = 0; i < this->entries.size(); i++) {
        uLCD.printf("  %s\n", this->entries[i]->label.c_str());
        }
    }
void Menu::clear_cursor(){
    uLCD.locate(0, Menu::selected_entry);
    uLCD.color(BLACK);
    uLCD.printf("*");
    }
void Menu::draw_cursor() {
    uLCD.locate(0, Menu::selected_entry);
    uLCD.color(GREEN);
    uLCD.printf("*");
    }
void Menu::update_cursor() {
    int new_selection = (int)(left_pot * Menu::active_menu->entries.size());
    if (new_selection == Menu::active_menu->entries.size()) new_selection--;
    if (new_selection != Menu::selected_entry) {
        clear_cursor();
        selected_entry = new_selection;
        draw_cursor();
    }
}
std::string Menu::run() {
    active_menu->draw();
    draw_cursor();
    while(1) {
        update_cursor();
        if(pushed) {
            wait(.5);
            pushed = false;
            //if(active_menu->entries.size() == 0)
             //   uLCD.printf("No Entries!");
            if (active_menu->entries[selected_entry]->select() == 1)
                continue;
            else
                return active_menu->entries[selected_entry]->label;
            }   
        }
    }
int Menu::select() {
    if (name == "END") {
        return 0;
    }
    if (onClick != NULL) {
        onClick();
        return 1;
    } else {
        set_active();
        draw();
        return 1;        
                
    }
    
    }
void Menu::add_child(Menu* child) {
    entries.push_back(child);
    child->parent = this;
    }