#include "main.h"
#include "mbed_rpc.h"
#include "multiboot.h"

static Serial pc(USBTX, USBRX);

int main(void)
{
    if(MultiBoot("/local/test.gba") == 1)
    {
        SystemError("MultiBoot", 1);
    }

    RpcDigitalOut myled1(LED1, "myled1");
    RpcDigitalOut myled2(LED2, "myled2");

    int var = 0;
    RPCVariable<int> _var(&var, "var");

    uint32_t r, cnt;
    char buf[256], outbuf[256];
 
    pc.printf("RPC GBA start\n");

    for(;;)
    {
        WaitSPI32(0x0, 0x00010000, "Wait start signature");

        outbuf[0] = '\0';
        cnt = 0;

        while((r = WriteSPI32NoDebug(0x0)) != 0x00020000)
        {
            *(uint32_t*)(&buf[cnt]) = r;
            cnt += 4;
        }

        RPC::call(buf, outbuf);
        pc.printf("buf:[%s]\n", buf);
        pc.printf("out:[%s]\n", outbuf);

        if(IsReadVariable(buf) == true)
        {
            WriteSPI32NoDebug(atoi(outbuf));
        }
    }
}

bool IsReadVariable(const char* request)
{
    if(request == NULL)
    {
        return false;
    }

    Arguments args(request);

    if(args.obj_name == NULL || args.method_name == NULL)
    {
        return false;
    }
    if(strcmp(args.method_name, "read") != 0)
    {
        return false;
    }

    return true;
}

void SystemError(char* str, uint32_t hex)
{
    pc.printf("[Err][0x%x] %s\n", hex, str);

    for(;;)
    {
        wait(1);
    }
}
