#include "crc.h"

static uint32_t r;

uint32_t crcU32n(uint32_t d)
{
    uint32_t bit;

    for(bit=0; bit<32; bit++)
    {
        if((r ^ d) & 0x01)
        {
            r = (r >> 1) ^ 0x0000c37b;
        }
        else
        {
            r = (r >> 1);
        }

        d = d >> 1;
    }

    return r;
}

uint32_t crcU32(uint32_t d)
{
    crcReset();
    return crcU32n(d);
}

void crcReset(void)
{
    r = 0x0000c387;
}
