#include "main.h"
#include "crc.h"
#include "multiboot.h"
#include "SDFileSystem.h"

static SDFileSystem sd(p11, p12, p13, p8, "sd");
static Serial pc(USBTX, USBRX);
 
int main(void)
{
    int ret = MultiBoot("/local/test.gba");
    if(ret == EXIT_FAILURE)
    {
        SystemError("MultiBoot", ret);
    }

    WaitSPI32(0x0, 0x1234abcd, "Wait for GBA(Calculate dump size)");

    uint32_t size    = WriteSPI32(0x0, "size");
    uint32_t sizeCRC = WriteSPI32(0x0, "sizeCRC");
    uint32_t crc     = crcU32(size);

    if(crc != sizeCRC)
    {
        SystemError("sizeCRC", crc);
    }
    pc.printf("sizeCRC OK!\n");

    FILE *fp = fopen("/sd/data.bin", "w");
    if(fp == NULL)
    {
        SystemError("Could not open file for write", 0);
    }

    uint32_t table[256/4];
    uint32_t cnt = 0;
    int i;

    pc.printf("data sending...(NoDebug)\n");
    crcReset();

    for(i=0; i<size/4; i++)
    {
        table[cnt] = WriteSPI32NoDebug(0x0);
        crc = crcU32n(table[cnt]);
        cnt++;

        if(cnt >= 256/4)
        {
            fwrite(&table, sizeof(uint32_t), 256/4, fp);
            cnt = 0;
        }

        wait_us(100);   // GBA too slow...
    }
    fclose(fp);

    uint32_t dataCRC = WriteSPI32(0x0, "dataCRC");
    if(crc != dataCRC)
    {
        SystemError("dataCRC", crc);
    }
    pc.printf("dataCRC OK!\n");


    pc.printf("All done\n");
    for(;;)
    {
        wait(1);
    }
}

void SystemError(char* str, uint32_t hex)
{
    pc.printf("[Err][0x%x] %s\n", hex, str);

    for(;;)
    {
        wait(1);
    }
}
    
