#include "cmd.h"
#include "mbed.h"
#include "apu.h"
#include "apu2.h"

// option
int g_loop     = 0;     // Loop
int g_verbose  = 0;     // Verbose
int g_debug    = 0;     // Debug mode

static int cmd_read_id666(FILE *fp, id666_tag *tag);
static void cmd_print_time(int seconds);

void cmd(char *filename)
{
    FILE *fp = fopen(filename, "rb");
    if(fp == NULL)
    {
        perror("fopen\n");
        return;
    }

    id666_tag tag;
    if(cmd_read_id666(fp, &tag))
    {
        perror("id666_tag\n");
        return;
    }

    printf("\nNow loading '%s' using 'embedded' algo\n", filename);
    if(LoadAPU_embedded(fp) < 0)
    {
        return;
    }

    BOLD();
    printf("Title: ");
    NORMAL();
    printf("%s\n", tag.title);
    
    BOLD();
    printf("Game Title: ");
    NORMAL();
    printf("%s\n", tag.game_title);

    BOLD();
    printf("Dumper: ");
    NORMAL();
    printf("%s\n", tag.name_of_dumper);

    BOLD();
    printf("Comments: ");
    NORMAL();
    printf("%s\n", tag.comments);

    BOLD();
    printf("Seconds: ");
    NORMAL();
    printf("%s\n", tag.seconds_til_fadeout);

    fclose(fp);


    int num_sec = atoi(tag.seconds_til_fadeout);
    int last_elaps_sec = -1;

    if(num_sec < 1 || num_sec > 999)
    {
        num_sec = 150;
    }
    if(strlen(tag.title) == 0)
    {
        strncpy(tag.title, filename, 32);
    }


    Timer t;
    t.start();

    for(;;)
    {
        int elaps_sec = t.read();

        if((!g_loop) && (elaps_sec > num_sec))
        {
            break;
        }
        
        if(last_elaps_sec != elaps_sec)
        {
            if(!g_loop)
            {
                BOLD();
                printf("Time: ");

                NORMAL();
                cmd_print_time(elaps_sec);
                printf(" [");
                cmd_print_time(num_sec - elaps_sec);
                printf("] of ");
                cmd_print_time(num_sec);
                printf(" \r");
            }
            else
            {
                BOLD();
                printf("Time: ");

                NORMAL();
                cmd_print_time(elaps_sec);
                printf(" \r");
            }
        }
        last_elaps_sec = elaps_sec;
        fflush(stdout);

        wait_ms(75);
    }

    printf("\nFinished playing.\n");
    apu_reset();
}

static int cmd_read_id666(FILE *fp, id666_tag *tag)
{
    long orig_pos = ftell(fp);
    unsigned char istag=0;

    fseek(fp, 0x23, SEEK_SET);
    fread(&istag, 1, 1, fp);

    if(istag != 26)
    {
        printf("No tag\n");
        strcpy(tag->title, "");
        strcpy(tag->game_title, "");
        strcpy(tag->name_of_dumper, "");
        strcpy(tag->comments, "");
        strcpy(tag->seconds_til_fadeout, "150"); // 2.5 minutes

        return 1;
    }
    
    fseek(fp, 0x2e, SEEK_SET);

    fread(&tag->title, 32, 1, fp);
    tag->title[32] = 0;

    fread(&tag->game_title, 32, 1, fp);
    tag->game_title[32] = 0;

    fread(&tag->name_of_dumper, 16, 1, fp);
    tag->name_of_dumper[16] = 0;

    fread(&tag->comments, 32, 1, fp);
    tag->comments[32] = 0;

    fseek(fp, 0xa9, SEEK_SET);

    fread(&tag->seconds_til_fadeout, 3, 1, fp);
    tag->seconds_til_fadeout[3] = 0;
    
    fseek(fp, orig_pos, SEEK_SET);

    return 0;
}

static void cmd_print_time(int seconds)
{
    int hour=0, min=0, sec=0;

    if(seconds >= 3600)
    {
        hour     = seconds / 3600;
        seconds -= hour * 3600;;
    }

    if(seconds >= 60)
    {
        min      = seconds / 60;
        seconds -= min * 60;
    }

    sec = seconds;

    printf("%02d:%02d:%02d", hour, min, sec);
}

void cmd_pspin_update(void)
{
    static int pspin_step = 0;

    switch(pspin_step)
    {
    default:
    case 4:
        pspin_step = 0;
    case 0:
        printf("|\b"); break;
    case 1:
        printf("/\b"); break;
    case 2:
        printf("-\b"); break;
    case 3:
        printf("\\\b"); break;
    }
    pspin_step++;

    fflush(stdout);
}
