#ifndef __apu2_h__
#define __apu2_h__


#include <stdio.h>

// offset in a .spc file
#define OFFSET_SPCDATA      0x100
#define OFFSET_DSPDATA      0x10100
#define OFFSET_SPCRAM       0x101c0

// Some SPC registers
#define SPC_PORT0           0xf4
#define SPC_PORT1           0xf5
#define SPC_PORT2           0xf6
#define SPC_PORT3           0xf7
#define SPC_TIMER0          0xfa
#define SPC_TIMER1          0xfb
#define SPC_TIMER2          0xfc
#define SPC_CONTROL         0xf1
#define SPC_REGADD          0xf2

// some Dsp registers address and bits
#define DSP_FLG             0x6C
#define DSP_FLG_RES         0x80
#define DSP_FLG_MUTE        0x40
#define DSP_FLG_ECEN        0x20
#define DSP_ESA             0x6D
#define DSP_EDL             0x7D
#define DSP_KON             0x4C

#define BOOT_SPC_PORT0      0x19
#define BOOT_SPC_PORT1      0x1f
#define BOOT_SPC_PORT2      0x25
#define BOOT_SPC_PORT3      0x2b
#define BOOT_SPC_TIMER2     0x07
#define BOOT_SPC_TIMER1     0x0a
#define BOOT_SPC_TIMER0     0x0d
#define BOOT_SPC_CONTROL    0x10
#define BOOT_DSP_FLG        0x38
#define BOOT_DSP_KON        0x3e
#define BOOT_SPC_REGADD     0x41
#define BOOT_A              0x47
#define BOOT_Y              0x49
#define BOOT_X              0x4b
#define BOOT_SP             0x44

int LoadAPU_embedded(FILE *fp);


#endif


/*


; Disassembled with spcdasm
; Source filename: ../DSPcode.bin
; Origin: $0002
; Input length: 16
p0002: MOV  $f2 , A        ; choose dsp register address (A)
p0004: CMP  A , $f4        
p0006: BNE  p0004          ; wait until Port0 equals A
p0008: MOV  $f3 , $f5      ; now we can copy the value in Port1 
                           ; to the selected dsp address
p000b: MOV  $f4 , A        ; say it's done by setting Port0 to the
                           ; dsp address
p000d: INC  A              ; increment A so we will expect the next address
p000e: BPL  p0002          ; while < 128, jump to p0002

; Jumps right after init code in rom, by underflowing
; the 16 bit program counter
p0010: BRA  pffc9          ; 2fb7




; Disassembled with spcdasm
; Source filename: ../Bootcode.bin
; Origin: $0000
; Input length: 77
p0000: MOV  $0 , #$0       ; $0001: ram $0000
p0003: MOV  $1 , #$0       ; $0004: ram $0001
p0006: MOV  $fc , #$ff     ; $0007: Timer2
p0009: MOV  $fb , #$ff     ; $000a: Timer1
p000c: MOV  $fa , #$4f     ; $000d: Timer0
p000f: MOV  $f1 , #$31     ; $0010: SPC Control reg
p0012: MOV  X , #$53       ;   
p0014: MOV  $f4 , X        ; 
p0016: MOV  A , $f4        ; 
p0018: CMP  A , #$0        ; $0019: Port0
p001a: BNE  p0016          ; 
p001c: MOV  A , $f5        ; 
p001e: CMP  A , #$0        ; $001f: Port1
p0020: BNE  p001c          ; 
p0022: MOV  A , $f6        ; 
p0024: CMP  A , #$0        ; $0024: Port2
p0026: BNE  p0022          ; 
p0028: MOV  A , $f7        ; 
p002a: CMP  A , #$0        ; $002b: Port3
p002c: BNE  p0028          ; 
p002e: MOV  A , $fd        ; 
p0030: MOV  A , $fe        ; 
p0032: MOV  A , $ff        ; 
p0034: MOV  $f2 , #$6c     ; point to flg register
p0037: MOV  $f3 , #$0      ; $0038: DSP FLG register
p003a: MOV  $f2 , #$4c     ; point to kon register
p003d: MOV  $f3 , #$0      ; $003e: DSP KON register
p0040: MOV  $f2 , #$7f     ; $0041: SPC dsp reg addr.
p0043: MOV  X , #$f5       ; $0044: SPC stack pointer
p0045: MOV  SP , X         ;
p0046: MOV  A , #$ff       ; $0047: SPC A register 
p0048: MOV  Y , #$0        ; $0049: SPC Y register
p004a: MOV  X , #$0        ; $004b: SPC X register
p004c: RETI                ; 


*/