#ifndef __apu_h__
#define __apu_h__


void apu_init(void);
void apu_reset(void);

unsigned char apu_read(int address);
void apu_write(int address, unsigned char data);
int apu_writeBytes(unsigned char *data, int len);
int apu_writeHandshake(int address, int data);

int apu_waitInport(int port, unsigned char data, int timeout_ms);

int apu_initTransfer(unsigned short address);
int apu_newTransfer(unsigned short address);
void apu_endTransfer(unsigned short start_address);


#endif
