#include "mbed.h"

#define  kanji_file    "/local/SHMZN16X.FNT"
//#defin  kanji_file  "/local/k12x10.fnt"
    
Serial device(p9, p10);  // tx, rx  LCD
DigitalOut rst(p20);     //P20  --> LCD  RST  (Reset)

LocalFileSystem local("local");

int cx = 0;
int cy = 0;
int offsety = 0;
bool kstate = false;
unsigned char kbuf;

    FILE *fp;   //File open buffer

    unsigned short start[92], end[92];
    unsigned char font[64];              

    char            Identifier[6+1];   
    char            FontName[8+1];    
    unsigned char    XSize;            
    unsigned char    YSize;            
    unsigned char    Size;            
    unsigned char    CodeType;        
    unsigned char    Tnum;            

#define FONT_XBYTE        ((XSize + 7) >> 3)
#define FONT_YBYTE        ((YSize + 7) >> 3)

void lcdspeed()
    {
    device.putc(0x55);// UART Speed 115200bps
    device.putc(0x05);
    device.putc(0x8B);
    device.putc(0x00);
    device.putc(0x01);
    device.putc(0xC2);
    device.putc(0x00);
    device.putc(0x4E);
    device.putc(0xAA);
    }
void bmp(int x0,int y0,int bmp_no)
    {
    unsigned char x0H;
    unsigned char x0L;
    unsigned char y0H;
    unsigned char y0L;
    unsigned char rH;
    unsigned char rL;
    unsigned char sum;

    x0H = x0 >> 8;
    x0L = x0 & 0xFF;
    y0H = y0 >> 8;
    y0L = y0 & 0xff;
    rH = bmp_no >> 8;
    rL = bmp_no & 0xFF;
    sum = x0H+x0L+y0H+y0L+rH+rL+0x09;
    device.putc(0x55);
    device.putc(0x07);
    device.putc(0x09);//command
    device.putc(x0H);
    device.putc(x0L);
    device.putc(y0H);
    device.putc(y0L);
    device.putc(rH);
    device.putc(rL);
    device.putc(sum);
    device.putc(0xAA);
    }

void cls()
    {
    device.putc(0x55);// Clear
    device.putc(0x02);
    device.putc(0x80);
    device.putc(0x55);
    device.putc(0xD5);
    device.putc(0xAA);
    }
void scroll(void){

}




void lcdputs( char data[98],int x,int y)
    {
    unsigned char s=0;
    unsigned char x0H;
    unsigned char x0L;
    unsigned char y0H;
    unsigned char y0L;
    unsigned char datalen;
    x0H = x >> 8;
    x0L = x & 0xFF;
    y0H = y >> 8;
    y0L = y & 0xFF;
    datalen = strlen(data)+5;
    device.putc(0x55);
    device.putc(datalen);
    device.putc(0x0B);  // command ASCII Print
    device.putc(x0H);   //x upper 8bit
    device.putc(x0L);   //x low 8bit
    device.putc(y0H);   //y upper 8bit
    device.putc(y0L);   //y low 8bit
    for(int a=0;a<strlen(data);a++)
        {
            device.putc(data[a]);
            s = s+data[a];
        }
    s = s+x0H+x0L+y0H+y0L+0x0B;
    device.putc(s);//sumcheck
    device.putc(0xAA);
    }

void color(int rgb)
    {
    int c1;
    int c2;
    int sum;
    
    c1=(rgb >> 8) & 0xff;
    c2=(rgb & 0xff);
    sum=c1+c2+0x84;
    device.putc(0x55);
    device.putc(0x03);
    device.putc(0x84);
    device.putc(c1);
    device.putc(c2);
    device.putc(sum);
    device.putc(0xAA);
    }

void newline(void){
    cx = 0;
    cy += 16;
    if(cy > 160){
        scroll();
        cy = 0;
        color(0x001f);
        cls();
        color(0xffff);
    }
}

void movecorsor(int a)
    {
    cx+=8*a;
    if(cx>=128) newline();
    }


void pixel(int x0,int y0)
    {
    unsigned char x0H;
    unsigned char x0L;
    unsigned char y0H;
    unsigned char y0L;
    unsigned char sum;

    x0H = x0 >> 8;
    x0L = x0 & 0xFF;
    y0H = y0 >> 8;
    y0L = y0 & 0xff;

    sum = x0H+x0L+y0H+y0L+0x01;
    device.putc(0x55);
    device.putc(0x05);
    device.putc(0x01);//command
    device.putc(x0H);
    device.putc(x0L);
    device.putc(y0H);
    device.putc(y0L);
    device.putc(sum);
    device.putc(0xAA);
    } 

void box(int x0,int y0,int x1,int y1,int paint)
    {
    unsigned char x0H;
    unsigned char x0L;
    unsigned char x1H;
    unsigned char x1L;
    unsigned char y0H;
    unsigned char y0L;
    unsigned char y1H;
    unsigned char y1L;
    unsigned char sum;
    unsigned char cmd;
    switch (paint)
    {
    case 1:
        cmd = 0x04;
        break;
    default:
        cmd =0x03;
        break;
    }
    x0H = x0 >> 8;
    x0L = x0 & 0xFF;
    y0H = y0 >> 8;
    y0L = y0 & 0xff;
    x1H = x1 >> 8;
    x1L = x1 & 0xFF;
    y1H = y1 >> 8;
    y1L = y1 & 0xff;
    sum = x0H+x0L+y0H+y0L+x1H+x1L+y1H+y1L+cmd;
    device.putc(0x55);//Box
    device.putc(0x09);
    device.putc(cmd);//command
    device.putc(x0H);
    device.putc(x0L);
    device.putc(y0H);
    device.putc(y0L);
    device.putc(x1H);
    device.putc(x1L);
    device.putc(y1H);
    device.putc(y1L);
    device.putc(sum);
    device.putc(0xAA);
    }

void circle(int x0,int y0,int r,int paint)
    {
    unsigned char x0H;
    unsigned char x0L;
    unsigned char y0H;
    unsigned char y0L;
    unsigned char rH;
    unsigned char rL;
    unsigned char sum;
    unsigned char cmd;
    switch (paint)
    {
    case 0:
        cmd = 0x05;
        break;
    case 1:
        cmd = 0x06;
        break;
    default:
        cmd =0x05;
        break;
    }
    x0H = x0 >> 8;
    x0L = x0 & 0xFF;
    y0H = y0 >> 8;
    y0L = y0 & 0xff;
    rH = r >> 8;
    rL = r & 0xFF;
    sum = x0H+x0L+y0H+y0L+rH+rL+cmd;
    device.putc(0x55);
    device.putc(0x07);
    device.putc(cmd);//command
    device.putc(x0H);
    device.putc(x0L);
    device.putc(y0H);
    device.putc(y0L);
    device.putc(rH);
    device.putc(rL);
    device.putc(sum);
    device.putc(0xAA);
    }

void line(int x0,int y0,int x1,int y1)
    {
    unsigned char x0H;
    unsigned char x0L;
    unsigned char x1H;
    unsigned char x1L;
    unsigned char y0H;
    unsigned char y0L;
    unsigned char y1H;
    unsigned char y1L;
    unsigned char sum;

    x0H = x0 >> 8;
    x0L = x0 & 0xFF;
    y0H = y0 >> 8;
    y0L = y0 & 0xff;
    x1H = x1 >> 8;
    x1L = x1 & 0xFF;
    y1H = y1 >> 8;
    y1L = y1 & 0xff;
    sum = x0H+x0L+y0H+y0L+x1H+x1L+y1H+y1L+02;
    device.putc(0x55);
    device.putc(0x09);
    device.putc(0x02);//command
    device.putc(x0H);
    device.putc(x0L);
    device.putc(y0H);
    device.putc(y0L);
    device.putc(x1H);
    device.putc(x1L);
    device.putc(y1H);
    device.putc(y1L);
    device.putc(sum);
    device.putc(0xAA);
    }
void lcdput(unsigned char data,int x,int y)
    {
    unsigned char s;
    unsigned char x0H;
    unsigned char x0L;
    unsigned char y0H;
    unsigned char y0L;
    unsigned char datalen;
    x0H = x >> 8;
    x0L = x & 0xFF;
    y0H = y >> 8;
    y0L = y & 0xFF;
    datalen = 6;
    device.putc(0x55);
    device.putc(datalen);
    device.putc(0x0B);  // command ASCII Print
    device.putc(x0H);   //x upper 8bit
    device.putc(x0L);   //x low 8bit
    device.putc(y0H);   //y upper 8bit
    device.putc(y0L);   //y low 8bit
    device.putc(data);
    s = data+x0H+x0L+y0H+y0L+0x0B;
    device.putc(s);//sumcheck
    device.putc(0xAA);
    }
    


void kanji_init(){ 
    //move cursor 
     fp = fopen(kanji_file , "r");


    if(!fp) {
        printf("File could not be opened!\n");
        exit(1);
    }

    fgets(Identifier,   6+1, fp);    // FONTX2
    fgets(FontName,     8+1, fp);        
    fread(&XSize,       1, 1, fp);        
    fread(&YSize,       1, 1, fp);        
    fread(&CodeType,    1, 1, fp);  
    fread(&Tnum,        1, 1, fp);

    // Table read
    for(int a=0;a< Tnum ;a++){
        fread(&start[a],1,2,fp);
        fread(&end[a]  ,1,2,fp);
        }
}

//Kanji puts  cr = kanji cord
void k_puts(int cr){
    //kanji address
    int c;
    int adrs;
    c=0;
    adrs=0;
    while(cr>start[c]){
        if(cr > end[c]){
            adrs += end[c]-start[c]+1;
            }
        else{
        adrs += cr - start[c];
        }
        c++;
    }
    c--;
                        //printf("C=%d,adrs=%d cr=%X ",c,adrs,cr);
    // Kanji image Read
    fseek( fp, Tnum*4+18+32*adrs, SEEK_SET );
    fread(&font,1,32,fp); 
    // kanji put
    c=0;
    for (int y=0;y<16;y++){
        for (int x=0;x<8;x++){
            if((font[c] & 0x80)==0x80){
                pixel(cx+x,cy+y);
                }
            font[c] = font[c] << 1;
            if((font[c+1] & 0x80)==0x80){
                pixel(cx+x+8,cy+y);
                }
            font[c+1] = font[c+1] << 1;
        }
        c+=2;
    }
    //move cursor 
    cx+=16;
    if(cx>=128){   //LF control
        cx=0;
        cy+=16;
        }
}

void kanji_end(){
    fclose(fp);
}

void drawc(unsigned char c){
    if(kstate){ // 2nd byte of shift-jis
        kstate = false;

       k_puts(kbuf << 8 | c);
    } else if((0x81 <= c && c <= 0x9f) || (0xe0 <= c && c <= 0xfc)){ // 1st byte of shift-jis
        kstate = true;
        kbuf = c;
    } else { // Ascii Out
        lcdput(c,cx,cy);
        movecorsor(1);  // 1byte Move
    }
}


void s_Lcdinit()
    {
//        device.baud(9600);
        rst = 0;            //Reset
        wait(0.1);
        rst = 1;
    wait(0.1);
    lcdspeed();//speed 115200
    wait(0.1);
    device.baud(115200);
    device.putc(0x55);//Back light On
    device.putc(0x03);
    device.putc(0x89);
    device.putc(0x01);
    device.putc(0x2C);
    device.putc(0xB6);
    device.putc(0xAA);
    bmp(0,0,1);
    lcdputs(" GingaX ",20,140);
    wait(3);
    bmp(0,0,0);
    wait(3);
    cls();
    color(0xffff);
    kanji_init();
    }

