#include "mbed.h"
#include "C12832.h"
#include "rtos.h"
#include "MMA7660.h"
#include "USBHostMSD.h"


//3-Axis Sensor port setting
MMA7660 MMA(p28, p27);

//Serial port setting with PC
Serial pc(USBTX,USBRX);
//LCD port setting
C12832 lcd(p5, p7, p6, p8, p11);
//LED setting connecting Temperature Sensor
DigitalOut led1(LED1);
DigitalOut led2(LED2);

float temper[3],abs1[1000];
long int counter, counter1=0;
int i;


void msd_task(void const *) {
    
    USBHostMSD msd("usb");
    float comp1[10] = {1.453, 0.141, -0.281, 0.047, -0.375, 1.453, 1.453, 0.797, 0.750, 0.797};
    float comp2[10] = {1.453, 0.844, 0.234, 0.188, -0.281, 0.656, 1.453, 1.031, 0.750, 0.703};
    float comp3[10] = {1.453, 1.453, -0.375, 0.188, 0.141, -0.469, 1.453, 1.453, 0.750, 0.844};
    float comp4[10] = {1.453, 1.406, -0.141, 0.141, 0.469, -0.047, -0.234, 1.453, 1.219, 0.891};
     while(1){
        
        // try to connect a MSD device
        while(!msd.connect()) {
            Thread::wait(1000);
        }
        
        FILE * fp = fopen("/usb/temp.csv", "w");
        
        // in a loop, append a file
        // if the device is disconnected, we try to connect it again
        for(i=0; i<1000; i++) {
            
            counter++;
            //temper[2]=(float)MMA.z();
            
            // append a file
            FILE * fp = fopen("/usb/temp.csv", "a");
        
            if (fp != NULL) {
                if((i<52&&i>=42)||(i<113&&i>=103)||(i<151&&i>=141)||(i<214&&i>=204)||(i<287&&i>=277)||(i<314&&i>=304)||(i<388&&i>=378)||(i<417&&i>=407)||(i<485&&i>=475)||(i<553&&i>=543)){
                    abs1[i]=(float)MMA.z()-comp1[i];
                }
                else{
                    abs1[i]=(float)MMA.z()-0.985;
                    }
                if((abs1[i]<0.215)&&((abs1[i-1]+abs1[i-2])/2)>-0.285){
                    fprintf(fp, "%ld,%.3f\n", counter, abs1[i]);
                    fclose(fp);
                    }
                else {
                    if((((abs1[i-1]+abs1[i-2]+abs1[i-3])/3)>-0.235)||(abs1[i-1]>-0.085)){
                        fprintf(fp, "%ld,%.3f\n", counter, abs1[i]);
                        fclose(fp);
                }
                    else{
                        led2=!led2;
                        counter1++;
                        fprintf(fp, "%ld,%.3f,%ld\n", counter, abs1[i],counter1);
                        fclose(fp);
                        }
                    }
            } else {
                printf("FILE == NULL\r\n");
            }
            if(i==999){
                i=0;
                }
            
            Thread::wait(100);
        
            // if device disconnected, try to connect again
            if (!msd.connected())
                break;
        }
    }
}

int main() {
    Thread msdTask(msd_task, NULL, osPriorityNormal, 1024 * 4);
    //Check connecting of 3-Axis
    if (MMA.testConnection()) printf("Sensor connect \n");
    while(1){
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("counter = %ld \n", counter);

        led1 = !led1;
        wait(0.1);
    }

}
