#include "mbed.h"
#include "LM75B.h"
#include "C12832.h"
#include "rtos.h"
#include "MMA7660.h"

//3-Axis Sensor port setting
MMA7660 MMA(p28, p27);
//Temperature Sensor port setting
LM75B sensor(p28,p27);
//LED setting connecting 3-Axis Sensor
DigitalOut MMA_X(LED2);
DigitalOut MMA_Y(LED3);
DigitalOut MMA_Z(LED4);
//Serial port setting with PC
Serial pc(USBTX,USBRX);
//LCD port setting
C12832 lcd(p5, p7, p6, p8, p11);
//LED setting connecting Temperature Sensor
DigitalOut led1(LED1);
//CAN port setting
CAN can1(p9, p10);
 


char counter, counter1, enter;
float temp;
float sensor_1[3];
//X-Axis thread
void led1_thread(void const *args){
    
    MMA_X = 0;
    while(1){
        sensor_1[0]=(float)MMA.x();
        if(sensor_1[0]>0.5) {
            MMA_X = 1;
            wait(1);
            MMA_X = 0; 
        }
        Thread::wait(100);
    }
}
//Y-Axis thread
void led2_thread(void const *args){
    
    MMA_Y = 0;
    while(1){
        sensor_1[1]=(float)MMA.y();
        if(sensor_1[1]>0.5) {
            MMA_Y = 1;
            wait(1);
            MMA_Y = 0; 
        }
        Thread::wait(100);
    }
}
//Z-Axis thread
void led3_thread(void const *args){
    
    MMA_Z = 0;
    while(1){
        sensor_1[2]=(float)MMA.z();
        if(sensor_1[2]<0.5) {
            MMA_Z = 1;
            wait(1);
            MMA_Z = 0; 
        }
        Thread::wait(100);
    }
}
//Float to Integer
int getInteger(float n)
{
    return (int)n;
}
//Getting Fracting of Float
int getFraction(float n)
{
    float a;
    a = n-getInteger(n);
    a = a*100;
    return (int)a;
}

int main() {
    //Declare thread of 3-Axis
    Thread thread1(led1_thread);
    Thread thread2(led2_thread);
    Thread thread3(led3_thread);
    //Check connecting of 3-Axis
    if (MMA.testConnection()) printf("Sensor connect \n");
    while(1){
        temp=sensor.read();
        counter=getInteger(temp);
        counter1=getFraction(temp);
        enter='1';
        lcd.cls();
        lcd.locate(0,3);
        lcd.printf("Temp = %.3f\n", temp);

        can1.write(CANMessage(1337, &counter, 1));
        wait(0.2);

        can1.write(CANMessage(1337, &counter1, 1));
        wait(0.2);

        can1.write(CANMessage(1337, &enter, 1));
        
        printf("Message sent : %d.%d \n", counter, counter1);
        led1 = !led1;
        wait(0.2);
    }

}
