#include "mbed.h"

#define EE_READ  0x400   // 10 XXXXXXXXX(A8-A0)
#define EE_WRITE 0x200   // 01 XXXXXXXXX(A8-A0)
#define EE_EWEN  0x1FF   // 00 11XXXXXXX(X is DONT CARE)
#define EE_EWDS  0x000   // 00 00XXXXXXX(X is DONT CARE)
#define EE_ERASE 0x600   // 11 XXXXXXXXX(A8-A0)

Serial device(PA_9, PA_10);  // tx, rx
DigitalOut CS(PC_0);
DigitalOut CK(PB_13);
DigitalIn  DI(PB_14);
DigitalOut DO(PB_15);

void vSend(unsigned short usCommand)
{
    signed char i=10;
    DO=1;        //SB
    CS=1;        // Chip Select High
    wait_us(1);  // SB Clock Generation
    CK=1;
    wait_us(1);
    CK=0;
    while(i>=0)
    {
        DO = (usCommand>>i)&0x01;
        i--;
        wait_us(1);
        CK=1;
        wait_us(1);
        CK=0;
    }
}
void vWriteEnable()
{
    vSend(EE_EWEN);
    wait_us(1);
    CS=0;  //Chip Select Low
}
void vWriteDisable()
{
    vSend(EE_EWDS);
    wait_us(1);
    CS=0;  //Chip Select Low
}
void vErase(unsigned short usAddr)
{
    vSend(EE_ERASE|usAddr);
    wait_us(1);
    CS=0;
/** wait busy flag clear */
    wait_us(1);     // tcs > 250ns @2.7V
    CS=1;
    wait_us(1);     // tsv < 250ns @2.7V
    while(DI==0); // 0.1ms < twp < 10ms 
    CS=0;
}
void vWrite(unsigned short usAddr, unsigned char ucData)
{
    signed char i=7;
    vSend(EE_WRITE|usAddr);
    for(i=7;i>=0;i--)
    {
        DO = (int)( (ucData>>i)&0x0001 );
        wait_us(1);
        CK=1;
        wait_us(1);
        CK=0;
    }
    CS=0;
/** wait busy flag clear */
    wait_us(1);     // tcs > 250ns @2.7V
    CS=1;
    wait_us(1);     // tsv < 250ns @2.7V
    while(DI==0); // 0.1ms < twp < 10ms 
    CS=0;
}
unsigned char ucRead(unsigned short usAddr)
{
    unsigned char data=0;
    signed char i=7;
    
    vSend(EE_READ|usAddr);
    wait_us(1);
    
    for(i=7;i>=0;i--)
    {
        CK=1;
        wait_us(1);
        CK=0;
        data = data | (DI<<i);
        wait_us(1);
    }
    CS=0;
    
    return data;
}
int main()
{
    unsigned char ucI=0;
    
    CS = 0;  //default state for Chip Select and Clock
    CK = 0;
    
    device.baud(19200);
    device.printf("The Program demostrating the IC AT93C56 EEPROM \r\n");

    device.printf("Going to Write Enable \r\n");    
    vWriteEnable();

    device.printf("Going to Erase Addr 0 \r\n");    
    vErase(0);
    device.printf("Going to Write Value AA to Addr 0 \r\n");    
    vWrite(0,0xAA);
    device.printf("Read Back Value %04X\r\n,",ucRead(0));
    
    device.printf("Going to Erase Addr 1 \r\n");    
    vErase(1);      
    device.printf("Going to Write Value BB to Addr 1 \r\n");    
    vWrite(1,0xBB);
    device.printf("Read Back Value %04X\r\n,",ucRead(1));

    device.printf("Going to Erase Addr 2 \r\n");    
    vErase(2);      
    device.printf("Going to Write Value CC to Addr 2 \r\n");    
    vWrite(2,0xCC);
    device.printf("Read Back Value %04X\r\n,",ucRead(2));
    
    device.printf("Going to Write Disable \r\n");   
    
    vWriteDisable();    
    
    while(1)
    {
        for(ucI=0;ucI<64;ucI++)
        {
            device.printf("%04X   ==============   %d\r\n,",ucRead(ucI),ucI);
            wait(0.5);
        }
    }
}
