#include "mbed.h"
#include <string>
#include "PinDetect.h"
#include "NeoStrip.h"

//# define MAX_FILE 30

#define N 32
NeoStrip strip(p5, 13);
float bright = 0.1; 

PinDetect b1(p25, PullUp);
PinDetect b2(p27, PullUp);
PinDetect b3(p26, PullUp);
//PinDetect b4(p26, PullUp);

LocalFileSystem local("local");               // Create the local filesystem under the name "local"
Serial pc(USBTX, USBRX); // tx, rx

void strip_off() {
    for (int i=0; i<N; i++) {
        strip.setPixel(i, 0);

    }
    strip.write();
}




AnalogIn V(p20); //interuppted for Voltage reader

DigitalOut led1(LED1); //mbedLED1
DigitalOut led2(LED2); //mbedLED2
DigitalOut led3(LED3); //mbedLED3
DigitalOut led4(LED4); //mbedLED4

PwmOut led_g1(p21);  //PWMout for led1
PwmOut led_g2(p22);  //PWMout for led2
PwmOut led_y1(p23);  //PWMout for led3
PwmOut led_y2(p23);  //PWMout for led4
PwmOut led_r1(p24);  //PWMout for led5
PwmOut led_r2(p24);  //PWMout for led6


Timer t;                // counts the time from beginning of main loop
InterruptIn beat(p8);   // beat is the name for a interrupt on pin 8

Ticker mscnt;           // this is used to create a ms counter

int count,CNT,displayBPMFlag;//initialize global variables 
float v; //variable for Volts
int BPM;   // variable for RPM

void ms_counter() {         //this interrupt routine starts every 1ms
    count++;                //the counter is increased with 1
    if (count>1999) {       //when no heart beat is detected for >2sec, then display "-" in the main loop
        CNT=count;          // copy counter value to CNT
        displayBPMFlag = 1; // set flag that the BPM can be put to LCD in the main loop
        count=0;            // reset counter value
    }
}

void flip() { //this interrupt routine starts on every heart beat
    CNT = count;        // copy counter value to CNT
    count = 0 ;         // reset counter value
    displayBPMFlag = 1; // set flag that the BPM can be put to LCD in the main loop
}

void brightnessUp(void) {
   
    if (bright > 0)
    {
    bright += 0.02;
    strip.setBrightness(bright);
    strip.setPixel(0, 0x000000);
    strip.setPixel(1, 0x000000);
    strip.setPixel(2, 0x000000);
    strip.setPixel(3, 0x000000);
    strip.setPixel(4, 0x000000);
    strip.setPixel(5, 0x000000);
    strip.setPixel(6, 0x000000);
    strip.setPixel(7, 0x000000);
    strip.setPixel(8, 0x000000);
    strip.setPixel(9, 0x000000);
    strip.setPixel(10, 0x000000);
    strip.setPixel(11, 0x000000);
    strip.setPixel(12, 0x000000);
    strip.write();
    strip_off();
    wait(0.25);
    strip.setPixel(0, 0x00ff00);
    strip.setPixel(1, 0x00ff00);
    strip.setPixel(2, 0x99ff00);
    strip.setPixel(3, 0x99ff00);
    strip.setPixel(4, 0xccff00);
    strip.setPixel(5, 0xccff00);
    strip.setPixel(6, 0xccff00);
    strip.setPixel(7, 0xffcc00);
    strip.setPixel(8, 0xffcc00);
    strip.setPixel(9, 0xff6600);
    strip.setPixel(10, 0xff6600);
    strip.setPixel(11, 0xff0000);
    strip.setPixel(12, 0xff0000);
    strip.write();
    strip_off();
     }
  }

void brightnessDown(void) {
   
    if (bright > 0)
    {
    bright -= 0.02;
    strip.setBrightness(bright);
    strip.setPixel(0, 0x000000);
    strip.setPixel(1, 0x000000);
    strip.setPixel(2, 0x000000);
    strip.setPixel(3, 0x000000);
    strip.setPixel(4, 0x000000);
    strip.setPixel(5, 0x000000);
    strip.setPixel(6, 0x000000);
    strip.setPixel(7, 0x000000);
    strip.setPixel(8, 0x000000);
    strip.setPixel(9, 0x000000);
    strip.setPixel(10, 0x000000);
    strip.setPixel(11, 0x000000);
    strip.setPixel(12, 0x000000);
    strip.write();
    strip_off();
    wait(0.25);
    strip.setPixel(0, 0x00ff00);
    strip.setPixel(1, 0x00ff00);
    strip.setPixel(2, 0x99ff00);
    strip.setPixel(3, 0x99ff00);
    strip.setPixel(4, 0xccff00);
    strip.setPixel(5, 0xccff00);
    strip.setPixel(6, 0xccff00);
    strip.setPixel(7, 0xffcc00);
    strip.setPixel(8, 0xffcc00);
    strip.setPixel(9, 0xff6600);
    strip.setPixel(10, 0xff6600);
    strip.setPixel(11, 0xff0000);
    strip.setPixel(12, 0xff0000);
    strip.write();
    strip_off();
     }
  }

void clearLED(void) {
    if (bright > 0)
    {
    
            strip.setPixel(0, 0x000000);
            strip.setPixel(1, 0x000000);
            strip.setPixel(2, 0x000000);
            strip.setPixel(3, 0x000000);
            strip.setPixel(4, 0x000000);
            strip.setPixel(5, 0x000000);
            strip.setPixel(6, 0x000000);
            strip.setPixel(7, 0x000000);
            strip.setPixel(8, 0x000000);
            strip.setPixel(9, 0x000000);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
            //strip_off();
            led_g1=0, led_g2=0, led_y1=0, led_y2=0, led_r1=0, led_r2=0, led1=0, led2=0, led3=0, led4=0;
    }
}

int main() {
      
      
    b1.setAssertValue( 0 );
    b2.setAssertValue( 0 );
    b3.setAssertValue( 0 );
    
    
    b1.attach_asserted( &clearLED );
    b2.attach_asserted( &brightnessUp);
    b3.attach_asserted( &brightnessDown );


    strip.setBrightness(bright);    // set default brightness

    b1.setSampleFrequency();
    b2.setSampleFrequency();
    b3.setSampleFrequency();
    
    
    //routine that tests all light by flicking them all on once
    led_g1=1, led_g2=0, led_y1=0, led_y2=0, led_r1=0, led_r2=0;
    wait(0.1);
    led_g1=0, led_g2=1, led_y1=0, led_y2=0, led_r1=0, led_r2=0;
    wait(0.1);
    //led_g1=0, led_g2=0, led_y1=1, led_y2=0, led_r1=0, led_r2=0;
    wait(0.1);
    led_g1=0, led_g2=0, led_y1=0, led_y2=1, led_r1=0, led_r2=0;
    wait(0.1);
    //led_g1=0, led_g2=0, led_y1=0, led_y2=0, led_r1=1, led_r2=0;
    wait(0.1);
    led_g1=0, led_g2=0, led_y1=0, led_y2=0, led_r1=0, led_r2=1;
    wait(0.1);   
    led_g1=0, led_g2=0, led_y1=0, led_y2=0, led_r1=0, led_r2=0, led1=1, led2=0, led3=0, led4=0;
    wait(0.1);
    led_g1=0, led_g2=0, led_y1=0, led_y2=0, led_r1=0, led_r2=0, led1=0, led2=1, led3=0, led4=0;
    wait(0.1);
    led_g1=0, led_g2=0, led_y1=0, led_y2=0, led_r1=0, led_r2=0, led1=0, led2=0, led3=1, led4=0;
    wait(0.1);
    led_g1=0, led_g2=0, led_y1=0, led_y2=0, led_r1=0, led_r2=0, led1=0, led2=0, led3=0, led4=1;
    wait(0.1);
    led4=0;
            strip.setPixel(0, 0x000000);
            strip.setPixel(1, 0x000000);
            strip.setPixel(2, 0x000000);
            strip.setPixel(3, 0x000000);
            strip.setPixel(4, 0x000000);
            strip.setPixel(5, 0x000000);
            strip.setPixel(6, 0x000000);
            strip.setPixel(7, 0x000000);
            strip.setPixel(8, 0x000000);
            strip.setPixel(9, 0x000000);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
            strip_off();
            wait(0.05);
        
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x000000);
            strip.setPixel(2, 0x000000);
            strip.setPixel(3, 0x000000);
            strip.setPixel(4, 0x000000);
            strip.setPixel(5, 0x000000);
            strip.setPixel(6, 0x000000);
            strip.setPixel(7, 0x000000);
            strip.setPixel(8, 0x000000);
            strip.setPixel(9, 0x000000);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
           // strip_off();
            
            
            wait(0.05);
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x000000);
            strip.setPixel(3, 0x000000);
            strip.setPixel(4, 0x000000);
            strip.setPixel(5, 0x000000);
            strip.setPixel(6, 0x000000);
            strip.setPixel(7, 0x000000);
            strip.setPixel(8, 0x000000);
            strip.setPixel(9, 0x000000);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
           // strip_off();
            
            
            wait(0.05);
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x99ff00);
            strip.setPixel(3, 0x000000);
            strip.setPixel(4, 0x000000);
            strip.setPixel(5, 0x000000);
            strip.setPixel(6, 0x000000);
            strip.setPixel(7, 0x000000);
            strip.setPixel(8, 0x000000);
            strip.setPixel(9, 0x000000);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
           // strip_off();
            
            
            wait(0.05);
            
             strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x99ff00);
            strip.setPixel(3, 0x99ff00);
            strip.setPixel(4, 0x000000);
            strip.setPixel(5, 0x000000);
            strip.setPixel(6, 0x000000);
            strip.setPixel(7, 0x000000);
            strip.setPixel(8, 0x000000);
            strip.setPixel(9, 0x000000);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
           // strip_off();
            
            
            wait(0.05);
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x99ff00);
            strip.setPixel(3, 0x99ff00);
            strip.setPixel(4, 0xccff00);
            strip.setPixel(5, 0x000000);
            strip.setPixel(6, 0x000000);
            strip.setPixel(7, 0x000000);
            strip.setPixel(8, 0x000000);
            strip.setPixel(9, 0x000000);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
           // strip_off();
            
            
            wait(0.05);
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x99ff00);
            strip.setPixel(3, 0x99ff00);
            strip.setPixel(4, 0xccff00);
            strip.setPixel(5, 0xccff00);
            strip.setPixel(6, 0x000000);
            strip.setPixel(7, 0x000000);
            strip.setPixel(8, 0x000000);
            strip.setPixel(9, 0x000000);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
           // strip_off();
            
            
            wait(0.05);
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x99ff00);
            strip.setPixel(3, 0x99ff00);
            strip.setPixel(4, 0xccff00);
            strip.setPixel(5, 0xccff00);
            strip.setPixel(6, 0xccff00);
            strip.setPixel(7, 0x000000);
            strip.setPixel(8, 0x000000);
            strip.setPixel(9, 0x000000);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
           // strip_off();
            
            
            wait(0.05);
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x99ff00);
            strip.setPixel(3, 0x99ff00);
            strip.setPixel(4, 0xccff00);
            strip.setPixel(5, 0xccff00);
            strip.setPixel(6, 0xccff00);
            strip.setPixel(7, 0xffcc00);
            strip.setPixel(8, 0x000000);
            strip.setPixel(9, 0x000000);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
           // strip_off();
            
            
            wait(0.05);
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x99ff00);
            strip.setPixel(3, 0x99ff00);
            strip.setPixel(4, 0xccff00);
            strip.setPixel(5, 0xccff00);
            strip.setPixel(6, 0xccff00);
            strip.setPixel(7, 0xffcc00);
            strip.setPixel(8, 0xffcc00);
            strip.setPixel(9, 0x000000);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
           // strip_off();
            
            
            wait(0.05);
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x99ff00);
            strip.setPixel(3, 0x99ff00);
            strip.setPixel(4, 0xccff00);
            strip.setPixel(5, 0xccff00);
            strip.setPixel(6, 0xccff00);
            strip.setPixel(7, 0xffcc00);
            strip.setPixel(8, 0xffcc00);
            strip.setPixel(9, 0xff6600);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
           // strip_off();
            
            
            wait(0.05);
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x99ff00);
            strip.setPixel(3, 0x99ff00);
            strip.setPixel(4, 0xccff00);
            strip.setPixel(5, 0xccff00);
            strip.setPixel(6, 0xccff00);
            strip.setPixel(7, 0xffcc00);
            strip.setPixel(8, 0xffcc00);
            strip.setPixel(9, 0xff6600);
            strip.setPixel(10, 0xff6600);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
           // strip_off();
            
            
            wait(0.05);
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x99ff00);
            strip.setPixel(3, 0x99ff00);
            strip.setPixel(4, 0xccff00);
            strip.setPixel(5, 0xccff00);
            strip.setPixel(6, 0xccff00);
            strip.setPixel(7, 0xffcc00);
            strip.setPixel(8, 0xffcc00);
            strip.setPixel(9, 0xff6600);
            strip.setPixel(10, 0xff6600);
            strip.setPixel(11, 0xff0000);
            strip.setPixel(12, 0x000000);
            strip.write();
           // strip_off();
            
            
            wait(0.05);
            
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x99ff00);
            strip.setPixel(3, 0x99ff00);
            strip.setPixel(4, 0xccff00);
            strip.setPixel(5, 0xccff00);
            strip.setPixel(6, 0xccff00);
            strip.setPixel(7, 0xffcc00);
            strip.setPixel(8, 0xffcc00);
            strip.setPixel(9, 0xff6600);
            strip.setPixel(10, 0xff6600);
            strip.setPixel(11, 0xff0000);
            strip.setPixel(12, 0xff0000);
            strip.write();
           // strip_off();
            led_g1=1, led_g2=1, led_y1=1, led_y2=1, led_r1=1, led_r2=1, led1=1, led2=1, led3=0, led4=0;     
            
             wait(0.05);
             
             
            led_g1=0, led_g2=0, led_y1=0, led_y2=0, led_r1=0, led_r2=0, led1=0, led2=0, led3=0, led4=0;
            strip.setPixel(0, 0x000000);
            strip.setPixel(1, 0x000000);
            strip.setPixel(2, 0x000000);
            strip.setPixel(3, 0x000000);
            strip.setPixel(4, 0x000000);
            strip.setPixel(5, 0x000000);
            strip.setPixel(6, 0x000000);
            strip.setPixel(7, 0x000000);
            strip.setPixel(8, 0x000000);
            strip.setPixel(9, 0x000000);
            strip.setPixel(10, 0x000000);
            strip.setPixel(11, 0x000000);
            strip.setPixel(12, 0x000000);
            strip.write();
            strip_off();
            wait(0.05);
            
            strip.setPixel(0, 0x00ff00);
            strip.setPixel(1, 0x00ff00);
            strip.setPixel(2, 0x99ff00);
            strip.setPixel(3, 0x99ff00);
            strip.setPixel(4, 0xccff00);
            strip.setPixel(5, 0xccff00);
            strip.setPixel(6, 0xccff00);
            strip.setPixel(7, 0xffcc00);
            strip.setPixel(8, 0xffcc00);
            strip.setPixel(9, 0xff6600);
            strip.setPixel(10, 0xff6600);
            strip.setPixel(11, 0xff0000);
            strip.setPixel(12, 0xff0000);
            strip.write();
           // strip_off();
            led_g1=1, led_g2=1, led_y1=1, led_y2=1, led_r1=1, led_r2=1, led1=1, led2=1, led3=0, led4=0;     
            
            

   pc.printf("\n\rDigital Frequency");  
   pc.printf("\n\rVoltmeter\n\r");  
   wait(1); //wait 1s
   
   mscnt.attach_us(&ms_counter,1000); //the address of the function to be attached (ms_counter) and the interval (1ms)
   
   
    t.start();                         //the time since the beginning of the main loop
    beat.rise(&flip);                  //the interrupt flip is started to the rising edge
    

       
    
    while (1) { 
             
           v = V;
          // v *= 3.3; //calculation for voltage reading
          
         //  pc.printf("\n\r%1.3fV", v );    //print volts to pc
         
           
         //  if (v==.5)
        //   {pc.printf("P");}//air ratio is perfect
        //   if(v<=.4)
        //   {pc.printf("L");}//air ratio is lean
        //   if(v>=.6)
        //   {pc.printf("R");}//air ratio is perfect
           
           pc.printf("\n\r%i RPM ",BPM);  //print RPM to textlcd
    
                           //program loops around in here
        if (displayBPMFlag == 1) {     //if the flag is set that the BPM can be used in the main loop
            displayBPMFlag = 0;        //clear displayBPMflag
            if (CNT>05&CNT<2000) {    //when heart rate is within 30-240BPM
                
                BPM = 200 + 110000/CNT;            //calculate BPM
               
                pc.printf("%i ms ",CNT);  
                pc.printf("%i RPM ",BPM);  
                pc.printf("\r\n",CNT);       
               
               
               
               if (BPM>500 && BPM<999)
                {led_g1=1, led_g2=0, led_y1=0, led_y2=0, led_r1=0, led_r2=0;
                led1=1, led2=0, led3=0, led4=0;
                strip.setPixel(0, 0x00ff00);
                strip.setPixel(1, 0x00ff00);
                strip.setPixel(2, 0x000000);
                strip.setPixel(3, 0x000000);
                strip.setPixel(4, 0x000000);
                strip.setPixel(5, 0x000000);
                strip.setPixel(6, 0x000000);
                strip.setPixel(7, 0x000000);
                strip.setPixel(8, 0x000000);
                strip.setPixel(9, 0x000000);
                strip.setPixel(10, 0x000000);
                strip.setPixel(11, 0x000000);
                strip.setPixel(12, 0x000000);
                strip.write();
                //strip_off();
                wait(0.001);
                }
               
               
                if (BPM>1000 && BPM<1499)
                {led_g1=1, led_g2=0, led_y1=0, led_y2=0, led_r1=0, led_r2=0;
                strip.setPixel(0, 0x00ff00);
                strip.setPixel(1, 0x00ff00);
                strip.setPixel(2, 0x00ff00);
                strip.setPixel(3, 0x00ff00);
                strip.setPixel(4, 0x000000);
                strip.setPixel(5, 0x000000);
                strip.setPixel(6, 0x000000);
                strip.setPixel(7, 0x000000);
                strip.setPixel(8, 0x000000);
                strip.setPixel(9, 0x000000);
                strip.setPixel(10, 0x000000);
                strip.setPixel(11, 0x000000);
                strip.setPixel(12, 0x000000);
                strip.write();
                //strip_off();
                wait(0.001);
                } 

                
                
                if (BPM>1500 && BPM<1999)
                {led_g1=1, led_g2=0, led_y1=0, led_y2=0, led_r1=0, led_r2=0;
                strip.setPixel(0, 0x00ff00);
                strip.setPixel(1, 0x00ff00);
                strip.setPixel(2, 0x00ff00);
                strip.setPixel(3, 0x00ff00);
                strip.setPixel(4, 0x99ff00);
                strip.setPixel(5, 0x99ff00);
                strip.setPixel(6, 0x000000);
                strip.setPixel(7, 0x000000);
                strip.setPixel(8, 0x000000);
                strip.setPixel(9, 0x000000);
                strip.setPixel(10, 0x000000);
                strip.setPixel(11, 0x000000);
                strip.setPixel(12, 0x000000);
                strip.write();
                //strip_off();
                wait(0.001);
                }    
                
                
                if (BPM>2000 && BPM<2499)
                {led_g1=1, led_g2=1, led_y1=0, led_y2=0, led_r1=0, led_r2=0; //light up 1,2 light  at 2000rpm 
                 led1=1, led2=0, led3=0, led4=0;
                strip.setPixel(0, 0x00ff00);
                strip.setPixel(1, 0x00ff00);
                strip.setPixel(2, 0x00ff00);
                strip.setPixel(3, 0x00ff00);
                strip.setPixel(4, 0x99ff00);
                strip.setPixel(5, 0x99ff00);
                strip.setPixel(6, 0x99ff00);
                strip.setPixel(7, 0x99ff00);
                strip.setPixel(8, 0x000000);
                strip.setPixel(9, 0x000000);
                strip.setPixel(10, 0x000000);
                strip.setPixel(11, 0x000000);
                strip.setPixel(12, 0x000000);
                strip.write();
                //strip_off();
                wait(0.001);
                 }
                 
                 
                 if (BPM>2500 && BPM<2999)
                {led_g1=1, led_g2=1, led_y1=0, led_y2=0, led_r1=0, led_r2=0; //light up 1,2 light  at 2000rpm 
                 led1=1, led2=0, led3=0, led4=0;
                strip.setPixel(0, 0x00ff00);
                strip.setPixel(1, 0x00ff00);
                strip.setPixel(2, 0x00ff00);
                strip.setPixel(3, 0x00ff00);
                strip.setPixel(4, 0x99ff00);
                strip.setPixel(5, 0x99ff00);
                strip.setPixel(6, 0x99ff00);
                strip.setPixel(7, 0x99ff00);
                strip.setPixel(8, 0xccff00);
                strip.setPixel(9, 0xccff00);
                strip.setPixel(10, 0x000000);
                strip.setPixel(11, 0x000000);
                strip.setPixel(12, 0x000000);
                strip.write();
                //strip_off();
                wait(0.001);
                 }
                 
                 
                
                if (BPM>3000 && BPM<3499)
                {led_g1=1, led_g2=1, led_y1=1, led_y2=1, led_r1=0, led_r2=0; //light up 1,2,3 light  at 3000rpm
                 led1=1, led2=0, led3=0, led4=0;
                strip.setPixel(0, 0x00ff00);
                strip.setPixel(1, 0x00ff00);
                strip.setPixel(2, 0x00ff00);
                strip.setPixel(3, 0x00ff00);
                strip.setPixel(4, 0x99ff00);
                strip.setPixel(5, 0x99ff00);
                strip.setPixel(6, 0x99ff00);
                strip.setPixel(7, 0x99ff00);
                strip.setPixel(8, 0xccff00);
                strip.setPixel(9, 0xccff00);
                strip.setPixel(10, 0xccff00);
                strip.setPixel(11, 0xccff00);
                strip.setPixel(12, 0x000000);
                strip.write();
                //strip_off();
                wait(0.001);
                }
                
                if (BPM>3500 && BPM<3999)
                {led_g1=1, led_g2=1, led_y1=1, led_y2=1, led_r1=1, led_r2=1;; //light up 1,2,3,4 light  at 4000rpm
                led1=1, led2=0, led3=0, led4=0;
                strip.setPixel(0, 0x00ff00);
                strip.setPixel(1, 0x00ff00);
                strip.setPixel(2, 0x00ff00);
                strip.setPixel(3, 0x00ff00);
                strip.setPixel(4, 0x99ff00);
                strip.setPixel(5, 0x99ff00);
                strip.setPixel(6, 0x99ff00);
                strip.setPixel(7, 0x99ff00);
                strip.setPixel(8, 0xccff00);
                strip.setPixel(9, 0xccff00);
                strip.setPixel(10, 0xccff00);
                strip.setPixel(11, 0xccff00);
                strip.setPixel(12, 0xffcc00);
                strip.write();
                //strip_off();
                wait(0.001);
                }
                
                if (BPM>4000 && BPM<4499)
                {led_g1=!led_g1, led_g2=!led_g2, led_y1=!led_y1, led_y2=!led_y2, led_r1=!led_r1, led_r2=!led_r2; //light up 1,2,3,4,5 light  at 5000rpm
                led1=1, led2=0, led3=0, led4=0;
                strip.setPixel(0, 0xffcc00);
                strip.setPixel(1, 0xffcc00);
                strip.setPixel(2, 0xffcc00);
                strip.setPixel(3, 0xffcc00);
                strip.setPixel(4, 0xffcc00);
                strip.setPixel(5, 0xffcc00);
                strip.setPixel(6, 0xffcc00);
                strip.setPixel(7, 0xffcc00);
                strip.setPixel(8, 0xffcc00);
                strip.setPixel(9, 0xffcc00);
                strip.setPixel(10, 0xffcc00);
                strip.setPixel(11, 0xffcc00);
                strip.setPixel(12, 0xffcc00);
                strip.write();
                //strip_off();
                wait(0.001);
                }
                
                if (BPM>4500 && BPM<4999)
                {led_g1=!led_g1, led_g2=!led_g2, led_y1=!led_y1, led_y2=!led_y2, led_r1=!led_r1, led_r2=!led_r2; //light up 1,2,3,4,5,6 light  at 5500rpm
                led1=1, led2=0, led3=0, led4=0;
                strip.setPixel(0, 0xffcc00);
                strip.setPixel(1, 0xffcc00);
                strip.setPixel(2, 0xffcc00);
                strip.setPixel(3, 0xffcc00);
                strip.setPixel(4, 0xffcc00);
                strip.setPixel(5, 0xffcc00);
                strip.setPixel(6, 0xffcc00);
                strip.setPixel(7, 0xff6600);
                strip.setPixel(8, 0xff6600);
                strip.setPixel(9, 0xff6600);
                strip.setPixel(10, 0xff6600);
                strip.setPixel(11, 0xff6600);
                strip.setPixel(12, 0xff6600);
                strip.write();
                //strip_off();
                wait(0.001);
                }
                
                if (BPM>5000 && BPM<5499)
                {led_g1=!led_g1, led_g2=!led_g2, led_y1=!led_y1, led_y2=!led_y2, led_r1=!led_r1, led_r2=!led_r2; //flash lights 1,2,3,4,5,6 at 6000rpm
                led1=!led1, led2=!led2, led3=!led3, led3=!led3, led4=!led4;
                strip.setPixel(0, 0xff6600);
                strip.setPixel(1, 0xff6600);
                strip.setPixel(2, 0xff6600);
                strip.setPixel(3, 0xff6600);
                strip.setPixel(4, 0xff6600);
                strip.setPixel(5, 0xff6600);
                strip.setPixel(6, 0xff6600);
                strip.setPixel(7, 0xff6600);
                strip.setPixel(8, 0xff6600);
                strip.setPixel(9, 0xff6600);
                strip.setPixel(10, 0xff6600);
                strip.setPixel(11, 0xff6600);
                strip.setPixel(12, 0xff6600);
                strip.write();
                //strip_off();
                wait(0.001);
                }
                
                
                if (BPM>5500 && BPM<5999)
                {led_g1=!led_g1, led_g2=!led_g2, led_y1=!led_y1, led_y2=!led_y2, led_r1=!led_r1, led_r2=!led_r2; //flash lights 1,2,3,4,5,6 at 6000rpm
                led1=!led1, led2=!led2, led3=!led3, led3=!led3, led4=!led4;
                strip.setPixel(0, 0xff6600);
                strip.setPixel(1, 0xff6600);
                strip.setPixel(2, 0xff6600);
                strip.setPixel(3, 0xff6600);
                strip.setPixel(4, 0xff6600);
                strip.setPixel(5, 0xff6600);
                strip.setPixel(6, 0xff6600);
                strip.setPixel(7, 0xff0000);
                strip.setPixel(8, 0xff0000);
                strip.setPixel(9, 0xff0000);
                strip.setPixel(10, 0xff0000);
                strip.setPixel(11, 0xff0000);
                strip.setPixel(12, 0xff0000);
                strip.write();
                //strip_off();
                wait(0.001);
                }
                
                if (BPM>6000&& BPM<6499)
                {led_g1=!led_g1, led_g2=!led_g2, led_y1=!led_y1, led_y2=!led_y2, led_r1=!led_r1, led_r2=!led_r2; //flash lights 1,2,3,4,5,6 at 6000rpm
                led1=!led1, led2=!led2, led3=!led3, led3=!led3, led4=!led4;
                strip.setPixel(0, 0xff0000);
                strip.setPixel(1, 0xff0000);
                strip.setPixel(2, 0xff0000);
                strip.setPixel(3, 0xff0000);
                strip.setPixel(4, 0xff0000);
                strip.setPixel(5, 0xff0000);
                strip.setPixel(6, 0xff0000);
                strip.setPixel(7, 0xff0000);
                strip.setPixel(8, 0xff0000);
                strip.setPixel(9, 0xff0000);
                strip.setPixel(10, 0xff0000);
                strip.setPixel(11, 0xff0000);
                strip.setPixel(12, 0xff0000);
                strip.write();
                //strip_off();
                wait(0.001);
                }
               
               
                if (BPM>6500 && BPM<6999)
                {led_g1=!led_g1, led_g2=!led_g2, led_y1=!led_y1, led_y2=!led_y2, led_r1=!led_r1, led_r2=!led_r2; //flash lights 1,2,3,4,5,6 at 6000rpm
                led1=!led1, led2=!led2, led3=!led3, led3=!led3, led4=!led4;
                strip.setPixel(0, 0xff0000);
                strip.setPixel(1, 0xff0000);
                strip.setPixel(2, 0xff0000);
                strip.setPixel(3, 0xff0000);
                strip.setPixel(4, 0xff0000);
                strip.setPixel(5, 0xff0000);
                strip.setPixel(6, 0xff0000);
                strip.setPixel(7, 0xff0000);
                strip.setPixel(8, 0xff0000);
                strip.setPixel(9, 0xff0000);
                strip.setPixel(10, 0xff0000);
                strip.setPixel(11, 0xff0000);
                strip.setPixel(12, 0xff0000);
                strip.write();
                //strip_off();
                wait(0.001);
                }
               
                
                
              
}
}
}
}
