#ifndef _ROS_map_msgs_ProjectedMap_h
#define _ROS_map_msgs_ProjectedMap_h

#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include "ros/msg.h"
#include "nav_msgs/OccupancyGrid.h"

namespace map_msgs
{

  class ProjectedMap : public ros::Msg
  {
    public:
      nav_msgs::OccupancyGrid map;
      float min_z;
      float max_z;

    ProjectedMap():
      map(),
      min_z(0),
      max_z(0)
    {
    }

    virtual int serialize(unsigned char *outbuffer) const
    {
      int offset = 0;
      offset += this->map.serialize(outbuffer + offset);
      offset += serializeAvrFloat64(outbuffer + offset, this->min_z);
      offset += serializeAvrFloat64(outbuffer + offset, this->max_z);
      return offset;
    }

    virtual int deserialize(unsigned char *inbuffer)
    {
      int offset = 0;
      offset += this->map.deserialize(inbuffer + offset);
      offset += deserializeAvrFloat64(inbuffer + offset, &(this->min_z));
      offset += deserializeAvrFloat64(inbuffer + offset, &(this->max_z));
     return offset;
    }

    const char * getType(){ return "map_msgs/ProjectedMap"; };
    const char * getMD5(){ return "7bbe8f96e45089681dc1ea7d023cbfca"; };

  };

}
#endif
