#include "MAG3110.h"

/******************************************************************************
 * Constructors
 ******************************************************************************/
MAG3110::MAG3110(PinName sda, PinName scl): _i2c(sda, scl)
{
    
}

void MAG3110::begin(int16_t off_x, int16_t off_y, int16_t off_z)
{
    char cmd[2];
    
    cmd[0] = MAG_CTRL_REG2;
    cmd[1] = 0b1 << 4;                           //reset overexposure
    _i2c.write(MAG_ADDR, cmd, 2);
    
    wait_ms(100);
    
    cmd[0] = MAG_CTRL_REG1;                     
    cmd[1] = 0x00;                              //Puts device in Standby mode
    _i2c.write(MAG_ADDR, cmd,2);   

    cmd[0] = MAG_CTRL_REG2;
    cmd[1] = 0x80;                              //Set Automatic Magnetic Sensor Reset bit
    _i2c.write(MAG_ADDR, cmd, 2);

    cmd[0] = MAG_CTRL_REG1;
    cmd[1] = 0x01;                              //Set ODR=80Hz and OSR=16 and set device to active mode.
    _i2c.write(MAG_ADDR, cmd, 2);
    
    char data_bytes[3];
    
    data_bytes[0]=MAG_OFF_X_MSB;                //Write offset values to X register
    data_bytes[1] = (off_x & 0xFF00) >> 8;
    data_bytes[2] = (off_x & 0xFF);
    _i2c.write(MAG_ADDR,data_bytes,3);
    wait_ms(10);
    
    data_bytes[0]=MAG_OFF_Y_MSB;                //Write offset values to Y register
    data_bytes[1] = (off_y & 0xFF00) >> 8;
    data_bytes[2] = (off_y & 0xFF);
    _i2c.write(MAG_ADDR,data_bytes,3);
    wait_ms(10);
    
    data_bytes[0]=MAG_OFF_Z_MSB;                //Write offset values to Z register
    data_bytes[1] = (off_z & 0xFF00) >> 8;
    data_bytes[2] = (off_z & 0xFF);
    _i2c.write(MAG_ADDR,data_bytes,3);
    wait_ms(10);
}

// Read a single byte form 8 bit register, return as int
int MAG3110::readReg(char regAddr)
{
    char cmd[1];

    cmd[0] = regAddr;
    _i2c.write(MAG_ADDR, cmd, 1);

    cmd[0] = 0x00;
    _i2c.read(MAG_ADDR, cmd, 1);
    return (int)( cmd[0]);
}


// read a register per, pass first reg value, reading 2 bytes increments register
// Reads MSB first then LSB
int MAG3110::readVal(char regAddr)
{
    char cmd[2];

    cmd[0] = regAddr;
    _i2c.write(MAG_ADDR, cmd, 1);

    cmd[0] = 0x00;
    cmd[1] = 0x00;
    _i2c.read(MAG_ADDR, cmd, 2);
    return (int)( (cmd[1]|(cmd[0] << 8))); //concatenate the MSB and LSB
}

void MAG3110::getValues(int *xVal, int *yVal, int *zVal)
{
    *xVal = readVal(MAG_OUT_X_MSB);
    *yVal = readVal(MAG_OUT_Y_MSB);
    *zVal = readVal(MAG_OUT_Z_MSB);
}


void MAG3110::setCalibration(float minX, float maxX, float minY, float maxY, float minZ, float maxZ)
{
    _avgX=(maxX+minX)/2;
    _avgY=(maxY+minY)/2;
    _avgZ=(maxZ+minZ)/2;
}

void MAG3110::get_uT(float * uT)
{
   
   char data_bytes[7];
   char d[1];
   d[0]=MAG_DR_STATUS;
   
   _i2c.write(MAG_ADDR,d,1,true);  
   _i2c.read(MAG_ADDR,data_bytes,7);// Read the 6 data bytes - LSB and MSB for X, Y and Z Axes.
    
   uT[0] =  (float)( (int16_t)data_bytes[1] << 8 | (int16_t)data_bytes[2] ) * 0.1;
   uT[1] =  (float)( (int16_t)data_bytes[3] << 8 | (int16_t)data_bytes[4] ) * 0.1;
   uT[2] =  (float)( (int16_t)data_bytes[5] << 8 | (int16_t)data_bytes[6] ) * 0.1;
   
   /*
   int xVal, yVal, zVal;
   
   getValues(&xVal,&yVal, &zVal);
   
   uT[0] =  (float)( xVal ) * 0.1;
   uT[1] =  (float)( yVal ) * 0.1;
   uT[2] =  (float)( zVal ) * 0.1;
   */
   
}



