/*
 *  Example of LidarLite library usage. The data from sensor registers is refreshed using refreshRange() / refreshVelocity() / refreshRangeVelocity() functions and 
 *  measurement data can be read into program using getRange_cm() / getVelocity_cms(). I separated the functions to refresh and report data for ease of upgrade to thread functions.
 *  
 *  Akash Vibhute   < akash . roboticist [at] gmail . com >
 *  
 *  v0.1, 17/Feb/2015 - First version of library, tested using LPC1768 [powered via mbed 3.3v, no additional pullups on I2C necessary]
 *
 */

#include "LidarLite.h"

#define LIDARLite1_SDA p9   //SDA pin on LPC1768
#define LIDARLite1_SCL p10  //SCL pin on LPC1768

LidarLite sensor1(LIDARLite1_SDA, LIDARLite1_SCL); //Define LIDAR Lite sensor 1

Timer dt;

Serial pc(USBTX,USBRX);

int main()
{    
    pc.baud(921600);
    dt.start();
    
    while(1)
    {
        //sensor1.refreshRange();
        //sensor1.refreshVelocity();
        sensor1.refreshRangeVelocity();
        
        pc.printf("range: %d cm, velocity: %d cm/s, rate: %.2f Hz\n", sensor1.getRange_cm(), sensor1.getVelocity_cms(), 1/dt.read());
        dt.reset();
    }
    
}