/*
 * Copyright (c) 2017 Helmut Tschemernjak
 * 30826 Garbsen (Hannover) Germany
 * Licensed under the Apache License, Version 2.0);
 */

#include "mbed.h"
#include "PinMap.h"
#include "BufferedSerial.h"
#include "sx1276-mbed-hal.h"

void SystemClock_Config(void);

extern BufferedSerial *ser;
extern void dump(const char *title, const void *data, int len, bool dwords = false);

#define dprintf(...) { ser->printf(__VA_ARGS__); ser->printf("\r\n"); }

int SX1276PingPong(void);
int SX1276Comm(bool mode, bool ack);
/*
 * Callback functions prototypes
 */
/*!
 * @brief Function to be executed on Radio Tx Done event
 */
void OnTxDone(void *radio);

/*!
 * @brief Function to be executed on Radio Rx Done event
 */
void OnRxDone(void *radio, uint8_t *payload, uint16_t size, int16_t rssi, int8_t snr );

/*!
 * @brief Function executed on Radio Tx Timeout event
 */
void OnTxTimeout(void *radio);

/*!
 * @brief Function executed on Radio Rx Timeout event
 */
void OnRxTimeout(void *radio);

/*!
 * @brief Function executed on Radio Rx Error event
 */
void OnRxError(void *radio);

/*!
 * @brief Function executed on Radio Fhss Change Channel event
 */
void OnFhssChangeChannel(void *radio, uint8_t channelIndex );

/*!
 * @brief Function executed on CAD Done event
 */
void OnCadDone(void *radio);