#include "mbed.h"
#include "L6470SDC.h"
 
int main(){
    //インスタンス化
    //USBシリアルとSPIとCSのピン別名を渡す
    L6470SDC l6470(USBTX, USBRX, SPI_MOSI, SPI_MISO, SPI_SCK, D10);
 
    wait(1);
 
    //L6470ドライバーの初期化
    l6470.init();
 
    wait(1);
 
    //1番目のモーターの最大速度を毎秒100ステップに設定
    l6470.setMaximumSpeed(1, l6470.calcMaxSpd(100));

    //0.02回転のみ回す
    for(int i = 0; i < 10; i++) {
        l6470.run(1, l6470.calcSpd(100), true);
        wait(0.2);
        l6470.stop(1);
     
        //モーターが完全停止するまで待つ
        while(l6470.isBusy(1));
     
        //回転して止めてる時間
        wait(5.0);
    }
 
    //それぞれのモーターの初期位置に戻る(zeroとhomeは別名の同一関数)
    l6470.home(1);
}
 