/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include <string.h>
#include <stdio.h>


// Blinking rate in milliseconds
#define BLINKING_RATE_MS                                                    500

AnalogIn capteurIR_G(A0);
AnalogIn capteurIR_D(A2);

PwmOut propulsion(D9);
PwmOut direction(D6);

DigitalIn BP1(D2);
DigitalIn BP2(D3);

//DigitalOut led(LED1);

static BufferedSerial serial_port(USBTX, USBRX,115200);
SPISlave device(D11, D12, D13, A3); // mosi, miso, sclk, ssel

int main()
{
    char text[50] = {};
    uint32_t bp1,bp1_old = 1;
    uint32_t bp2,bp2_old = 1;
    uint32_t pulsewidth_direction = 1100;
    uint16_t capteurIR_g,capteurIR_d;
    propulsion.period_us(20000);
    propulsion.pulsewidth_us(1500);
    direction.period_us(20000);
    direction.pulsewidth_us(pulsewidth_direction);
    while (true) {
        bp1 = BP1.read();
        bp2 = BP2.read();
        
        if(!bp1 && bp1_old)
        {
            led = !led;
            if(pulsewidth_direction >1000)
            {
                pulsewidth_direction -= 10;
            }
            direction.pulsewidth_us(pulsewidth_direction);
            sprintf(text,"pulsewidth_direction = %d\n\r",pulsewidth_direction);
            serial_port.write(text,strlen(text));
            capteurIR_g = capteurIR_G.read_u16();
            sprintf(text,"capteurIR G = %d\n\r",capteurIR_g);
            serial_port.write(text,strlen(text));
        }
        
        if(!bp2 && bp2_old)
        {
            if(pulsewidth_direction < 1300)
            {
                pulsewidth_direction += 10;
            }
            direction.pulsewidth_us(pulsewidth_direction);
            sprintf(text,"pulsewidth_direction = %d\n\r",pulsewidth_direction);
            serial_port.write(text,strlen(text));
            capteurIR_d = capteurIR_D.read_u16();
            sprintf(text,"capteurIR D = %d\n\r",capteurIR_d);
            serial_port.write(text,strlen(text));
        }
        
        if (device.receive()) {
            int v = device.read();   // Read byte from master
            //v = (v + 1) % 0x100;     // Add one to it, modulo 256
            //device.reply(v);         // Make this the next reply
            sprintf(text,"valeur du caractere recu SPI : %d\n\r",v);
            serial_port.write(text,strlen(text));
            if(v=='a')
                led = 1;
            else if (v=='e')
                led = 0;
        }
        
        bp1_old = bp1;
        bp2_old = bp2;
        //thread_sleep_for(BLINKING_RATE_MS);
    }
}
