#include "mbed.h"
#include "QEI.h"

DigitalOut  my_led(LED1);
DigitalIn   bouton(USER_BUTTON);
PwmOut      pwm_moteur1(PA_8);
DigitalOut  Enable(PB_5);
PwmOut      pwm_moteur2(PB_3);
Serial      pc(USBTX,USBRX);
QEI         codeur(D8, D9, NC, 48, QEI::X4_ENCODING );
AnalogOut   sortie_position(A2);
AnalogIn    entree_consigne(A0);
Ticker      ticker_regul;
        
void moteur(float ratio);

void boucle_regul(void){
    float consigne;
    float position_roue;
    static float erreur;
    static float Ierreur;
    float Kp = 0.05;
    float KiTe = 0.00001;

    Ierreur = Ierreur + erreur;
    consigne = entree_consigne * 360.0;
    position_roue = ( ((codeur.getPulses()*10)%9792) * 36.0/(48*20.4) );
    erreur = consigne - position_roue;
    moteur(Kp * erreur + KiTe *Ierreur );
    sortie_position.write(position_roue/360.0);
    
    }

int main()
{
    
    pwm_moteur1.period_us(50);
    pwm_moteur2.period_us(50);
    pwm_moteur2.write(0);
    Enable = 1;
    ticker_regul.attach(&boucle_regul,0.001);
    
    pc.printf("TP asservissement position\n\r");
    
    while (1) {
     
    }
}

void moteur(float ratio){
    if (ratio >= (float)0.0) {
        pwm_moteur1.write(0);
        pwm_moteur2.write(ratio);
    }
    else{
        pwm_moteur1.write(-ratio);
        pwm_moteur2.write(0);
    }       
}
        