#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "string.h"

CAN canbus(PB_8, PB_9);
DigitalIn bp1(PG_6);
DigitalOut led1(PI_1);
DigitalOut led2(PB_14);


int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t idx;
    uint32_t i=0,id,id_old,line=20;
    uint8_t data[8];
    CANMessage msg;
    char text[50]="Prepa Agreg Externe Epreuve 5";
    char text2[10];
    canbus.frequency(125000);
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    BSP_LCD_Clear(LCD_COLOR_DARKBLUE);
    BSP_LCD_SetFont(&Font12);
    BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
    BSP_LCD_SetTextColor(LCD_COLOR_DARKBLUE);
    BSP_LCD_DisplayStringAt(0, 2, (uint8_t *)text, CENTER_MODE);
    BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());

    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_SetBackColor(LCD_COLOR_DARKBLUE);


    while (1) {
        if (canbus.read(msg)) {
            led1=!led1;
            id=msg.id;
            sprintf(text,"Message received: %4d", msg.id);
            for(i=0; i<8; i++) {
                sprintf(text2," %2X ", msg.data[i]);
                strcat(text,text2);
            }
            if(id != id_old) {
                line = line + 13;
                if (line > 250) line = 20;
            }
            BSP_LCD_DisplayStringAt(0, line, (uint8_t *)text, LEFT_MODE);
            id_old= id;
        }
        
        led2.write(bp1.read());
        
        BSP_TS_GetState(&TS_State);
        if (TS_State.touchDetected) {
            x = TS_State.touchX[0];
            y = TS_State.touchY[0];
            if((x>10)&&(x<470)&&(y>10)&&(y<262))
            BSP_LCD_FillCircle(x,y,5);
        }
    }
}
