#include "mbed.h"

int main()
{
    float const pi = 3.14159265359;
    
    // Initialise the digital pins D3, D5 and D6 as PWM outputs
    PwmOut red(D2);
    PwmOut green(D3);
    PwmOut blue(D4);

    // Loop forever...
    while (true) {
        // Loop the 'angle' variable from 0 to 359
        for (int angle = 0; angle < 360; angle++) {
            // Set the intensities of the LEDs
            red = 0.5+0.5*sin(angle*pi/180);
            green = 0.5+0.5*sin((angle+120)*pi/180);
            blue = 0.5+0.5*sin((angle+240)*pi/180);
            // The angle will change by one degree every 20ms
            thread_sleep_for(20);
        }
    }
}
