#include "Adafruit_BluefruitLE_SPI.h"

#ifdef NDEBUG
#define ASSERT_WITH_MSG(expr,msg) ((void)0)
#else
#define ASSERT_WITH_MSG(expr,msg)                        \
do {                                                     \
    if (!(expr)) {                                       \
        mbed_assert_internal(msg, __FILE__, __LINE__);   \
    }                                                    \
} while (0)
#endif

#define MINIMUM_FIRMWARE_VERSION    "0.6.6"
#define MODE_LED_BEHAVIOUR          "MODE"

class BluetoothUart : public Adafruit_BluefruitLE_SPI
{
public:
    BluetoothUart(PinName mosi, PinName miso, PinName sclk, PinName cs, PinName irq, PinName rst = NC):
        Adafruit_BluefruitLE_SPI(mosi, miso, sclk, cs, irq, rst)
    {
        ASSERT_WITH_MSG(begin(), "Couldn't find Bluefruit module - check wiring?");
        ASSERT_WITH_MSG(factoryReset(), "Couldn't factory reset Bluefruit module");
        if ( isVersionAtLeast(MINIMUM_FIRMWARE_VERSION) ) {
            sendCommandCheckOK("AT+HWModeLED=" MODE_LED_BEHAVIOUR);
        }
        setMode(BLUEFRUIT_MODE_DATA);
    }
};
