// Copyright 2020 Georgia Tech.  All rights reserved.
// The materials provided by the instructor in this course are for
// the use of the students currently enrolled in the course.
// Copyrighted course materials may not be further disseminated.
// This file must not be made publicly available anywhere.

#include "graphics.h"

#include "globals.h"

void draw_nothing(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, BLACK);
}

void draw_img(int u, int v, const char* img)
{
    int colors[11*11];
    for (int i = 0; i < 11*11; i++)
    {
        if (img[i] == 'R') colors[i] = RED;
        else if (img[i] == 'Y') colors[i] = 0xFFFF00; // Yellow
        else if (img[i] == 'G') colors[i] = GREEN;
        else if (img[i] == 'T') colors[i] = 0x008080;
        else if (img[i] == 'Q') colors[i] = 0xFFFFFF;
        else if (img[i] == 'S') colors[i] = 0x0000FF;
        else if (img[i] == 'M') colors[i] = 0xFFD700;
        else if (img[i] == 'D') colors[i] = 0xD2691E; // "Dirt"
        else if (img[i] == 'C') colors[i] = 0x84563C;
        else if (img[i] == 'L') colors[i] = 0xADD8E6;
        else if (img[i] == '5') colors[i] = LGREY; // 50% grey
        else if (img[i] == '3') colors[i] = DGREY;
        else colors[i] = BLACK;
    }
    uLCD.BLIT(u, v, 11, 11, colors);
    wait_us(250); // Recovery time!
}

void draw_wall(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, LGREY);
    uLCD.filled_rectangle(u, v, u+1, v, 0xFFFF00);
    uLCD.filled_rectangle(u+3, v, u+4, v, 0xFFFF00);
    uLCD.filled_rectangle(u+6, v, u+7, v, 0xFFFF00);
    uLCD.filled_rectangle(u+9, v, u+10, v, 0xFFFF00);
    uLCD.filled_rectangle(u, v+2, u+1, v+2, 0xFFFF00);
    uLCD.filled_rectangle(u+3, v+2, u+4, v+2, 0xFFFF00);
    uLCD.filled_rectangle(u+6, v+2, u+7, v+2, 0xFFFF00);
    uLCD.filled_rectangle(u+9, v+2, u+10, v+2, 0xFFFF00);
    uLCD.filled_rectangle(u, v+4, u+1, v+4, 0xFFFF00);
    uLCD.filled_rectangle(u+3, v+4, u+4, v+4, 0xFFFF00);
    uLCD.filled_rectangle(u+6, v+4, u+7, v+4, 0xFFFF00);
    uLCD.filled_rectangle(u+9, v+4, u+10, v+4, 0xFFFF00);
    uLCD.filled_rectangle(u, v+6, u+1, v+6, 0xFFFF00);
    uLCD.filled_rectangle(u+3, v+6, u+4, v+6, 0xFFFF00);
    uLCD.filled_rectangle(u+6, v+6, u+7, v+6, 0xFFFF00);
    uLCD.filled_rectangle(u+9, v+6, u+10, v+6, 0xFFFF00);
    uLCD.filled_rectangle(u, v+8, u+1, v+8, 0xFFFF00);
    uLCD.filled_rectangle(u+3, v+8, u+4, v+8, 0xFFFF00);
    uLCD.filled_rectangle(u+6, v+8, u+7, v+8, 0xFFFF00);
    uLCD.filled_rectangle(u+9, v+8, u+10, v+8, 0xFFFF00);
     uLCD.filled_rectangle(u, v+10, u+1, v+10, 0xFFFF00);
    uLCD.filled_rectangle(u+3, v+10, u+4, v+10, 0xFFFF00);
    uLCD.filled_rectangle(u+6, v+10, u+7, v+10, 0xFFFF00);
    uLCD.filled_rectangle(u+9, v+10, u+10, v+10, 0xFFFF00);
    
}

void draw_plant(int u, int v)
{
   char plant[122] = "BGGGGGGGGGBGGGGGGGGGGGGGGGGGGGGGGBGGGGGGGGGBBBGGGGGGGBBBBBBMMMBBBBBBBBMMMBBBBBDDDDDDDDDBBBDDDDDDDBBBBBDDDDDBBBBBBBDDDBBBB";
   draw_img(u, v, plant);
}

void draw_goodie(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, 0xD9BE91);
    //uLCD.filled_rectangle(u, v, u, v, 0xFFFF00);zzzz
    uLCD.filled_rectangle(u+1, v+1, u+4, v+3, 0xFFD700);
    uLCD.filled_rectangle(u+6, v+1, u+9, v+3, 0xFFD700);
    uLCD.filled_rectangle(u+1, v+7, u+4, v+9, 0xFFD700);
    uLCD.filled_rectangle(u+6, v+7, u+9, v+9, 0xFFD700);
    //uLCD.filled_rectangle(u+4, v+4, u+2, v+2, 0xFFFFFF);
}

void draw_snake_body(int u, int v)
{
    uLCD.filled_rectangle(u, v, u+10, v+10, GREEN);
}

void draw_snake_head(int u, int v)
{
     //May need to design a snake head sprite
     //Tile still need to be designed on paper

    uLCD.filled_rectangle(u, v, u+10, v+10, GREEN);
    uLCD.filled_rectangle(u+1, v+1, u+3, v+1, RED);
    uLCD.filled_rectangle(u+7, v+1, u+9, v+1, RED);
    uLCD.filled_rectangle(u+1, v+3, u+3, v+4, RED);
    uLCD.filled_rectangle(u+7, v+3, u+9, v+4, RED);
    uLCD.filled_rectangle(u+1, v+7, u+3, v+9, RED);
    uLCD.filled_rectangle(u+7, v+7, u+9, v+9, RED);
}

void draw_snake_tail(int u, int v)
{
     //May need to design a snake tail sprite
     //Tile still need to be designed on paper
    uLCD.filled_rectangle(u, v, u+10, v+10, GREEN);
    uLCD.filled_rectangle(u+1, v+1, u+3, v+3, 0xFFFF00);
    uLCD.filled_rectangle(u+7, v+1, u+9, v+3, 0xFFFF00);
    uLCD.filled_rectangle(u+1, v+7, u+3, v+9, 0xFFFF00);
    uLCD.filled_rectangle(u+7, v+7, u+9, v+9, 0xFFFF00);
    
}

void draw_shield(int u, int v)
{
    char shield[122] = "QQQQQQQQQQQQBBBBBBBBBQQBSSSSSSSBQQBQBBBBBQBQQBQBQQQBQBQQBBQBBBQBBQBQBBQQQBBQBBBQBBBBBQBBBBBQQQQQBBBBBBBBBBBBBBBBBBBBBBBBB";
    draw_img(u, v, shield);
}

void draw_life(int u, int v) {
    char life[122] =    "BBBBBBBBBBBBBRRRBBRRRBBRRRRBRRRRRBRRRRRRRRRRBRRRRRRRRRRBRRRRRRRRRBBBRRRRRRRBBBBBRRRRRBBBBBBBRRRBBBBBBBBBBBBBBBBBBBBBBBBBB";
    draw_img(u, v, life);
}

void draw_snowflake(int u, int v) {
    char snowflake[122] = "BBBBBQBBBBBQBBBBQBBBBQBBQBBQBBQBBBQQBQBQBQQBBBBQQQQQBBBQQQBQBQBQQQBBBQQQQQBBBBQQBQBQBQQBBBQBBQBBQBBQBBBBQBBBBQBBBBBQBBBBB";
    draw_img(u, v, snowflake);
}
void draw_sword(int u, int v) {
    char sword[122] = "BBBBBBBBBBB55BBBBBBBBB5Q5BBBBBBBBB5Q5BBBBBBBBB5Q5BBBBBBBBB5Q5DDBBBBBBB33DBBBBBBBBDDMBBBBBBBBDBBMBBBBBBBBBBBMBB";
    draw_img(u, v, sword);
}
void draw_arrow_up(int u, int v) {
    char arrowup[122] = "BBBBRRBBBBBBBBRRRRBBBBBBRRRRRRBBBBRRRRRRRRBBRRRRRRRRRRBBBRRRRRRBBBBBRRRRRRBBBBBRRRRRRBBBBBRRRRRRBBBBBRRRRRRBBBBBRRRRRRBBB";
    draw_img(u, v, arrowup);
}
void draw_arrow_down(int u, int v) {
    char arrowdown[122] = "BBRRRRRRBBBBBRRRRRRBBBBBRRRRRRBBBBBRRRRRRBBBBBRRRRRRBBBBBRRRRRRBBBRRRRRRRRRRBBRRRRRRRRBBBBRRRRRRBBBBBBRRRRBBBBBBBBRRBBBBB";
    draw_img(u, v, arrowdown);
}
  
void draw_arrow_right(int u, int v) {
    char arrowright[122] = "BBBBBBRBBBBBBBBBBRRBBBRRRRRRRRRBBRRRRRRRRRRBRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRBRRRRRRRRRBBBBBBBBRRBBBBBBBBBRBBBB";
    draw_img(u, v, arrowright);
}  

void draw_arrow_left(int u, int v) {
    char arrowleft[122] = "BBBBRBBBBBBBBBRRBBBBBBBBRRRRRRRRRBRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRBRRRRRRRRRRBBRRRRRRRRRBBBRRBBBBBBBBBBRBBBBBB";
    draw_img(u, v, arrowleft);
}

void draw_lightspeed(int u, int v) {
    char lightspeed[122] = "BBBBBBBBYBBBBBBBBBYYBBBBBBBBYYYBBBBBBBYYYBBBBBBBYYYYYYBBBBYYYYYYBBBBBBBYYYBBBBBBBYYYBBBBBBBYYYBBBBBBBBYBBBBBBB";
    draw_img(u, v, lightspeed);
}

void draw_blue_wall(int u, int v) {
    char bluewall[122] = "SSQSSQSSQSSQQSQQSQQSQQSSQSSQSSQSSQQSQQSQQSQQSSQSSQSSQSSQQSQQSQQSQQSSQSSQSSQSSQQSQQSQQSQQSSQSSQSSQSSQQSQQSQQSQQSSQSSQSSQSS";
    draw_img(u, v, bluewall);
}

void draw_reverse(int u, int v) {
    char reverse[122] = "BBBBBBBBBBBBBBBBBBBBBBBBBYBBBBBBBBBYYYYYYYYBBYYYYYYYYYBBBYYYYYYYYBBBBYBBBGBBBBGGGGGGGGBBBGGGGGGGGGBBGGGGGGGGBBBBBBBBBGBBB";
    draw_img(u, v, reverse);
}
   
void draw_blue_potion(int u, int v) {
    char bluepotion[122] = "BBBBBBBBBBBBBBBDDDBBBBBBBQDDDQBBBBBBQBBBQBBBBBBQBBBQBBBBBQBBBBBQBBBQBBBBBBBQBBQSSSSSSSQBBQSSSSSSSQBBBQSSSSSQBBBBBQQQQQBBB";
    draw_img(u, v, bluepotion);
} 

void draw_red_potion(int u, int v) {
    char redpotion[122] = "BBBBBBBBBBBBBBBDDDBBBBBBBQDDDQBBBBBBQBBBQBBBBBBQBBBQBBBBBQBBBBBQBBBQBBBBBBBQBBQRRRRRRRQBBQRRRRRRRQBBBQRRRRRQBBBBBQQQQQBBB";
    draw_img(u, v, redpotion);
} 

void draw_portal(int u, int v) {
    char portal[122] = "BBBBSSSBBBBBBBSLLLSBBBBBSLLLLLSBBBSLLLLLLLSBBSLLLLLLLSBBSLLLLLLLSBBSLLLLLLLSBBSLLLLLLLSBBBSLLLLLSBBBBBSLLLSBBBBBBBSSSBBB";  
    draw_img(u, v, portal);  

}






