#include "mbed.h"
#include "SDFileSystem.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"

EthernetNetIf ethif( IpAddr(10,0,0,200), // IP
                     IpAddr(255,255,255,0), // Subnet mask
                     IpAddr(10,0,0,1),   // Gateway
                     IpAddr(8,8,8,8) ); // DNS
HTTPServer server;
SDFileSystem sd(p5, p6, p7, p8, "sd"); // Define local file mount point

DigitalOut led1(LED1);  // for alive check
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

int main(void)
{
    Base::add_rpc_class<DigitalOut>();
    
    // EthernetNetIf setup
    if( ethif.setup() ) {
        return 1;
    }

    // Mount local file path on web root path
    FSHandler::mount("/sd", "/");
    // Set web root path handler
    server.addHandler<FSHandler>("/");
    server.addHandler<RPCHandler>("/rpc"); 

    // Set http port
    server.bind(80);

    Timer tm;
    tm.start();
    // flash LED1 to show the server is still operating
    while(1) {
        Net::poll();
        if( 1.0 < tm.read() ) {
            led1 = !led1;   // high->low, low->high
            tm.start();
        }
    }
}