// Template of player header file
#ifndef PLAYER_H
#define PLAYER_H

// Player settings
#define PLAYER_WIDTH   10 
#define PLAYER_HEIGHT  3
#define PLAYER_DELTA   3
#define PLAYER_COLOR   0x0000FF
#define BLACK_COLOR    0x000000
#define YELLOW_COLOR   0xFFFF00  
#define GREEN_COLOR    0x00FF00




typedef enum {
    PLAYER_MISSILE_EXPLODED=2,///<missile has been destroyed
    PLAYER_MISSILE_ACTIVE=1,///<missile is active
    PLAYER_MISSILE_DEACTIVE=0///<missile is no longer active
} PLAYER_MISSILE_STATUS;
//Initialize ANTI-missile structure

typedef struct {
    int x;   
    int origin_y;                ///< The x-coordinate of missile current position
    int y;                   ///< The y-coordinate of missile current position
    int source_x;
    int source_y;                 
    PLAYER_MISSILE_STATUS status;   ///< The missile status, see MISSILE_STATUS
    
} PLAYER_MISSILE;
//Initialize PLAYER structure
typedef struct {
    int x;
    int y;
    int numMissile;
    int lives;   
     
            
    } PLAYER;
//Declare functions
void player_missile_draw(PLAYER_MISSILE player_missile, int color);
void player_draw(int x, int y);
void player_delete(int x, int y);
void missile_start(int counter);
void player_set_exploded(int index);
void gameover(int s);

#endif //PLAYER_H