#include "missile_private.h"

MISSILE missile_record[MAX_NUM_MISSILE];
int missile_tick=0;
int missile_interval = 10;
int missile_speed = 4;

// See the comments in missile_public.h
void missile_generator(void){
    missile_tick++;
    // only fire the missile at certain ticks
    if((missile_tick % missile_interval)==0 || missile_tick==0){
        missile_create();
    }
    
    // update the missiles and draw them
    missile_update_position();
}

// set missile speed (default speed is 4)
void set_missile_speed(int speed){
    ASSERT_P(speed>=1 && speed<=8,ERROR_MISSILE_SPEED);
    if(speed>=1 && speed<=8){  
        missile_speed = speed;
    }
}

// set missile interval (default interval is 10)
void set_missile_interval(int interval){
    ASSERT_P(interval>=1 && interval<=100,ERROR_MISSILE_INTERVAL);
    if(interval>=1 && interval<=100){
        missile_interval = interval;
    }
}

// See the comments in missile_public.h
MISSILE missile_get_info(int index){
    // All interface for user should have error checking
    ASSERT_P(index<MAX_NUM_MISSILE,ERROR_MISSILE_INDEX_GET_INFO);
    
    return missile_record[index];
}

// See the comments in missile_public.h
void missile_set_exploded(int index){
    // All interface for user should have error checking
    ASSERT_P(index<MAX_NUM_MISSILE,ERROR_MISSILE_INDEX_UPDATE_STATUS);
    
    missile_record[index].status = MISSILE_EXPLODED;
}

/** This function finds an empty slot of missile record, and active it.
*/
void missile_create(void){
    int i;
    for(i=0;i<MAX_NUM_MISSILE;i++){
        if(missile_record[i].status == MISSILE_DEACTIVE){
            missile_record[i].y = 0;
            //each missile has its own tick
            missile_record[i].tick = 0;
            //set a random source for the missile
            missile_record[i].source_x = rand() % SIZE_X;
            //set a random target for the missile
            missile_record[i].target_x = rand() % SIZE_X;
            //the missile starts at its source
            missile_record[i].x = missile_record[i].source_x;
            missile_record[i].status = MISSILE_ACTIVE;
            break;
        }
    }
}

/** This function update the position of all missiles and draw them
*/
void missile_update_position(void){
    int i;
    //controls how fast the missile will move
    int rate = missile_speed * 25;
    //delta_x and delta_y account for the slope of the missile
    double delta_x,delta_y;
    for(i=0;i<MAX_NUM_MISSILE;i++){
        if(missile_record[i].status == MISSILE_ACTIVE){
            // update missile position
            delta_y = 200/rate;
            delta_x = (missile_record[i].target_x - missile_record[i].source_x)/rate;
            missile_draw(missile_record[i], BACKGROUND_COLOR);
            missile_record[i].y = (int)(delta_y*(missile_record[i].tick%rate));
            missile_record[i].x = (int)(missile_record[i].source_x + delta_x*(missile_record[i].tick%rate));
            // draw missile
            missile_draw(missile_record[i], MISSILE_COLOR);
            //update missile's internal tick
            missile_record[i].tick++;
        }       
        else if(missile_record[i].status == MISSILE_EXPLODED){
            // clear the missile on the screen
            missile_draw(missile_record[i], BACKGROUND_COLOR);
            
            // we have done with this missile, remove it from record
            missile_record[i].status = MISSILE_DEACTIVE;
            //resets the missile's internal tick
            missile_record[i].tick = 0;
        }
        
    }
}

/** This function draw a missile.
    @param missile The missile to be drawn
    @param color The color of the missile
*/
void missile_draw(MISSILE missile, int color){
    int init_x,init_y,current_x,current_y;

    init_x = missile.source_x;
    init_y = 0;
    current_x = missile.x;
    current_y = missile.y;
    uLCD.line(init_x, init_y, current_x, current_y, color);
}


