#include "mbed.h"
#include "nRF24L01P.h"
#include "USBMouse.h"
#include "TSISensor.h"
#include "MMA8451Q.h"
#define MMA8451_I2C_ADDRESS (0x1d<<1) 
MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);
Serial pc(USBTX, USBRX); // tx, rx
 
nRF24L01P my_nrf24l01p(PTD6, PTE3, PTE2, PTB8, PTB9, PTD0);    // mosi, miso, sck, csn, ce, irq

 
 TSISensor tsi;
USBMouse mouse;
float value;
int xaxis, yaxis, zaxis;

int main()
{   
    char count[4];
    char TxDataCnt;
    
    char RxDataCnt;
    char temp;

    
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2510);
      
   if(count[3]==0)
   {
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Simple Transmitter (0 - 9 Counter) \r\n");

    TxDataCnt = 4;
    my_nrf24l01p.setTransferSize(TxDataCnt);

    my_nrf24l01p.enable();

    
        
    while (1) {
count[2]=tsi.readPercentage()*100;
    count[0]=(acc.getAccX()+1)*100;
        count[1]=(acc.getAccY()+1)*100;
        // Send the Transmit buffer via the nRF24L01+
        temp = my_nrf24l01p.write( NRF24L01P_PIPE_P0,count, TxDataCnt );

        pc.printf( "Sending %d - %d %d %d\r\n",temp,count[0],count[1],count[2],count[3]);

        // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
        
            
        if ( count[0] >=280 || count[1] >= 280 )
        {count[3]++;
         break;}
        
        
    }
    
    
    
    }
    
    
    if( count[3]==1)
    {
        // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Simple 2 Byte Receiver\r\n" );
    
    RxDataCnt = 3;
    my_nrf24l01p.setTransferSize( RxDataCnt );
    
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();

    while (1) {

        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {

            // ...read the data into the receive buffer
            temp = my_nrf24l01p.read( NRF24L01P_PIPE_P0, count, RxDataCnt );


            pc.printf( "%d %d %d\r\n",count[0],count[1],count[2]);

int xaxis = int(count[0]);
int yaxis = int(count[1]);
int value = int(count[2]);


            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            if( xaxis >=0 && xaxis <=50 )
    mouse.move(0,-3);
    
    if( xaxis >=150 && xaxis <=200 )
    mouse.move(0,3);
    
    if( xaxis >50 && xaxis <=80 )
    mouse.move(0,-1);
    
    if( xaxis >=120 && xaxis <150 )
    mouse.move(0,1);
    
    
    
    if( yaxis >50 && yaxis <=80 )
    mouse.move(1,0);
    
    if( yaxis >=120 && yaxis <150 )
    mouse.move(-1,0);
    
    if( yaxis >=0 && yaxis <=50 )
    mouse.move(3,0);
    
    if( yaxis >=150 && yaxis <=200 )
    mouse.move(-3,0);
    
    if( xaxis >=0 && xaxis <=80 && yaxis >=0 && yaxis <=80 )
    mouse.move(2,-2);
    
    if( xaxis >=120 && xaxis <=200 && yaxis >=0 && yaxis <=80 )
    mouse.move(2,2);
    
    if( xaxis >=0 && xaxis <=80 && yaxis >=120 && yaxis <=200 )
    mouse.move(-2,-2);
    
    if( xaxis >=120 && xaxis <=200 && yaxis >=120 && yaxis <=200)
    mouse.move(-2,2);
    
    if(value>50)
    {mouse.press(MOUSE_LEFT);
     wait(0.1);
     mouse.release(MOUSE_LEFT);
    }
    
    if(value<50 && value>0)
    {mouse.press(MOUSE_RIGHT);
     wait(0.1);
     mouse.release(MOUSE_RIGHT);
    }
    else
     mouse.move(0,0);
     
     if ( xaxis >=280 || yaxis >= 280 )
        {count[3]=0;
         break;}
        }
    }
    }
    
}
