#include "mbed.h"
#include "nRF24L01P.h"
#include "USBMouse.h"
Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD6, PTE3, PTE2, PTB8, PTB9, PTD0);    // mosi, miso, sck, csn, ce, irq
DigitalOut GreenLED(LED2);
USBMouse mouse;
char count[3] = {'\0'};
int main() {
    
    
    char RxDataCnt;
    char temp;

    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2510);

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Simple 2 Byte Receiver\r\n" );
    
    RxDataCnt = 3;
    my_nrf24l01p.setTransferSize( RxDataCnt );
    
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();

    while (1) {

        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {

            // ...read the data into the receive buffer
            temp = my_nrf24l01p.read( NRF24L01P_PIPE_P0, count, RxDataCnt );


            pc.printf( "%d %d %d\r\n",count[0],count[1],count[2]);

int xaxis = int(count[0]);
int yaxis = int(count[1]);
int value = int(count[2]);


            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            if( xaxis >=0 && xaxis <=50 )
    mouse.move(0,-3);
    
    if( xaxis >=150 && xaxis <=200 )
    mouse.move(0,3);
    
    if( xaxis >50 && xaxis <=80 )
    mouse.move(0,-1);
    
    if( xaxis >=120 && xaxis <150 )
    mouse.move(0,1);
    
    
    
    if( yaxis >50 && yaxis <=80 )
    mouse.move(1,0);
    
    if( yaxis >=120 && yaxis <150 )
    mouse.move(-1,0);
    
    if( yaxis >=0 && yaxis <=50 )
    mouse.move(3,0);
    
    if( yaxis >=150 && yaxis <=200 )
    mouse.move(-3,0);
    
    if( xaxis >=0 && xaxis <=80 && yaxis >=0 && yaxis <=80 )
    mouse.move(2,-2);
    
    if( xaxis >=120 && xaxis <=200 && yaxis >=0 && yaxis <=80 )
    mouse.move(2,2);
    
    if( xaxis >=0 && xaxis <=80 && yaxis >=120 && yaxis <=200 )
    mouse.move(-2,-2);
    
    if( xaxis >=120 && xaxis <=200 && yaxis >=120 && yaxis <=200)
    mouse.move(-2,2);
    
    if(value>50)
    {mouse.press(MOUSE_LEFT);
     wait(0.1);
     mouse.release(MOUSE_LEFT);
    }
    
    if(value<50 && value>0)
    {mouse.press(MOUSE_RIGHT);
     wait(0.1);
     mouse.release(MOUSE_RIGHT);
    }
    else
     mouse.move(0,0);
        }
    }
}
