
#include "tsl45315.hpp"

namespace TSL45x
{

TSL45315::TSL45315( PinName p_sda, PinName p_scl, int i2c_freq, float t ): _i2c( p_sda, p_scl )
{
    _i2c.frequency( i2c_freq );
    getIDdata();
    setReg( CONTROL_REG, NORMAL_OP);
    setReg( CONFIG_REG, M1);
    setMultiplier( M1 );
    _luxTicker.attach( this, &TSL45315::getLuxData, t );
}

TSL45315::TSL45315( PinName p_sda, PinName p_scl, int i2c_freq, float t, uint8_t mult ): _i2c( p_sda, p_scl )
{
    _i2c.frequency( i2c_freq );
    getIDdata( );
    setReg( CONTROL_REG, NORMAL_OP );
    setReg( CONFIG_REG, mult );
    setMultiplier( mult );
    _luxTicker.attach( this, &TSL45315::getLuxData, t );
}

TSL45315::TSL45315( PinName p_sda, PinName p_scl, uint8_t mult ): _i2c( p_sda, p_scl )
{
    _i2c.frequency( I2C_FREQ );
    getIDdata( );
    setReg( CONTROL_REG, NORMAL_OP );
    setReg( CONFIG_REG, mult );
    setMultiplier( mult );
}

TSL45315::TSL45315( PinName p_sda, PinName p_scl): _i2c( p_sda, p_scl )
{
    _i2c.frequency( I2C_FREQ );
    getIDdata( );
    setReg( CONTROL_REG, NORMAL_OP );
    setReg( CONFIG_REG, M1 );
    setMultiplier( M1 );
}

void TSL45315::setMultiplier( uint8_t mult )
{
    switch( mult ) {
        case 0:
            multiplier = 1;
            break;
        case 1:
            multiplier = 2;
            break;
        case 2:
            multiplier = 4;
            break;
        default:
            multiplier = 0;
            break;
    }
}

void TSL45315::setReg( int reg, int arg )
{
    char cmd[2];
    cmd[0] = ( 0x80|reg );
    cmd[1] =  arg;
    _i2c.write( I2C_ADDR, cmd, 2 );
}


void TSL45315::getIDdata( )
{
    char id[1];
    id[0]= 0;

    char cmd[1];
    cmd[0] = (0x80|ID_REG);
    _i2c.write(I2C_ADDR, cmd, 1);
    _i2c.read(I2C_ADDR, id, 1);

    devID = ( id[0]&0xF0 );   
}

void TSL45315::getLuxData( )
{
    char data[2];
    char cmd[1];
    cmd[0] = (0x80|DATALOW_REG);
    _i2c.write(I2C_ADDR, cmd, 1);
    _i2c.read(I2C_ADDR, data, 2);
    lux =uint32_t( (data[1]<<8)|data[0] );
    lux *= multiplier;
}
}