#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

/*
    SET DHCP
*/
#define USE_DHCP    1
//--------- Have to modify the mac address-------------
unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x12,0x34,0x56};

/* IP SET */
//char IP_Addr[] = "192.168.0.100";
//char IP_Subnet[] = "255.255.255.0";
//char IP_Gateway[] = "192.168.0.1";

Serial pc(USBTX, USBRX);

EthernetInterface ethernet;

AnalogIn Sensor(A0);

int main() {


  ///  mbed_mac_address((char *)MAC_Addr); //Use mbed mac addres
    pc.baud(9600);
    #if USE_DHCP
    int ret = ethernet.init(MAC_Addr);
    #else
    int ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
    #endif
    if (!ret) {
        pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
        ret = ethernet.connect();
        if (!ret) {
            pc.printf("IP: %s, MASK: %s, GW: %s\r\n",
                      ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
        } else {
            pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
            exit(0);
        }
    } else {
        pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
        exit(0);
    }
    
    char str[512];
    char msg[128]= "";
    
    /*
        http://dweet.io/follow/nameYouWant
    */
    //char nameYouWant[] = "mysensor2";
    char nameYouWant[] = "ccatest";

    while(1)
    {
        sprintf(msg,"http://dweet.io/dweet/for/%s?a0=%d",nameYouWant,(int)(Sensor.read()*1000));
        HTTPClient http;
        
        pc.printf("Send post message to dweet.io\r\n");
        pc.printf("msg : %s\r\n",msg);
        ret = http.get(msg, str, sizeof(str));
        if(!ret)
        {
          pc.printf("\r\nPage fetched successfully - read %d characters\r\n", strlen(str));
          pc.printf("Result: %s\r\n", str);
        }
        else
        {
          pc.printf("Error - ret = %d - HTTP return code = %d\n", ret, http.getHTTPResponseCode());
        }
        wait(5);
        
    }
   
}
