#include <ctype.h>

#include "mbed.h"

#include "jsmn.h"

#define       MAXTOKEN       64

const char *jsmn_type_str[] = {
  "PRIMITIVE",
  "OBJECT",
  "ARRAY",
  "STRING"
};


int main()
{
  const char *js;            // Pointer to json string
  int         r;             // Number of token parsed
  jsmn_parser p;             // jsmn parser
  jsmntok_t   t[MAXTOKEN];   // Parsed token

  // JSON may contain multibyte characters or encoded unicode in
  // \uXXXX format.
  // mbed compiler may complain "invalid multibyte character sequence".
  js =
"{"
"  \"menu\":"
"  {"
"    \"id\": 1234,"
"    \"group\": \"File\","
"    \"popup\":"
"    {"
"      \"menuitem\":"
"      ["
"        {\"value\": true,    \"onclick\"  : \"বিশাল\"},"
"        {\"value\": false,   0x1328       : \"groß\"},"
"        {\"value\": null,    \"15\u00f8C\": \"3\u0111\"},"
"        {\"value\": \"測試\", -12.34       :  99}"
"      ]"
"    }"
"  }"
"}";

  jsmn_init(&p);
  r = jsmn_parse(&p, js, strlen(js), t, MAXTOKEN);

  printf("Parsed %d tokens\n", r);
  
  printf("            TYPE       START   END  SIZE PAR\n");
  printf("           ----------  -----  ----  ---- ---\n");

  char        ch;
  jsmntok_t   at;            // A token for general use
  for (int i = 0; i < r; i++)
  {
    at = t[i];
    printf("Token %2d = %-10.10s (%4d - %4d, %3d, %2d) --> ",
           i, jsmn_type_str[at.type],
           at.start, at.end,
           at.size, at.parent);

    switch (at.type)
    {
      case JSMN_STRING:
        printf("%-10.*s\n", at.end - at.start + 2, js + at.start - 1);
        break;

      case JSMN_PRIMITIVE:
        ch = *(js + at.start);

        if (isdigit(ch) || ch == '-') 
          printf("%-10.*s\n", at.end - at.start, js + at.start);
        else if (tolower(ch) == 'n')
          printf("null\n");
        else if (tolower(ch) == 't')
          printf("true\n");
        else if (tolower(ch) == 'f')
          printf("false\n");
        break;

      default:
        printf("\n");
        break;
    }
  }
 
  while (1)
    ;
}
